/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemWaterBowl
extends ItemBase {
    public ItemWaterBowl() {
        super(ActuallyItems.defaultProps().stacksTo(1));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.getLevel() != null && ((Boolean)CommonConfig.Other.WATER_BOWL.get()).booleanValue() && !event.getItemStack().isEmpty() && event.getItemStack().is(Items.BOWL)) {
            BlockState state;
            BlockHitResult trace = ItemWaterBowl.getPlayerPOVHitResult((Level)event.getLevel(), (Player)event.getEntity(), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (trace.getType() != HitResult.Type.BLOCK) {
                return;
            }
            InteractionResultHolder result = EventHooks.onBucketUse((Player)event.getEntity(), (Level)event.getLevel(), (ItemStack)event.getItemStack(), (HitResult)trace);
            if (result == null && event.getEntity().mayUseItemAt(trace.getBlockPos().relative(trace.getDirection()), trace.getDirection(), event.getItemStack()) && (state = event.getLevel().getBlockState(trace.getBlockPos())).getFluidState().is((Fluid)Fluids.WATER) && (Integer)state.getValue((Property)BlockStateProperties.LEVEL) == 0) {
                event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
                if (!event.getLevel().isClientSide) {
                    event.getLevel().setBlock(trace.getBlockPos(), Blocks.AIR.defaultBlockState(), 11);
                    ItemStack reduced = StackUtil.shrink(event.getItemStack(), 1);
                    ItemStack bowl = new ItemStack((ItemLike)ActuallyItems.WATER_BOWL.get());
                    if (!StackUtil.isValid(reduced)) {
                        event.getEntity().setItemInHand(event.getHand(), bowl);
                    } else if (!event.getEntity().getInventory().add(bowl.copy())) {
                        ItemEntity entityItem = new ItemEntity(event.getLevel(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), bowl.copy());
                        entityItem.setPickUpDelay(0);
                        event.getLevel().addFreshEntity((Entity)entityItem);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        BlockPos pos1;
        HitResult trace;
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder result = EventHooks.onBucketUse((Player)player, (Level)world, (ItemStack)stack, (HitResult)(trace = player.pick(8.0, 1.0f, false)));
        if (result != null) {
            return result;
        }
        if (trace == null) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (trace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult blockTrace = (BlockHitResult)trace;
        BlockPos pos = blockTrace.getBlockPos();
        if (!world.mayInteract(player, pos)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        BlockPos blockPos = pos1 = world.getBlockState(pos).canBeReplaced() && blockTrace.getDirection() == Direction.UP ? pos : pos.relative(blockTrace.getDirection());
        if (!player.mayUseItemAt(pos1, blockTrace.getDirection(), stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (this.tryPlaceContainedLiquid(player, world, pos1, false)) {
            return !player.isCreative() ? InteractionResultHolder.success((Object)new ItemStack((ItemLike)Items.BOWL)) : InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.isClientSide && ((Boolean)CommonConfig.Other.WATER_BOWL_LOSS.get()).booleanValue() && world.getGameTime() % 10L == 0L && world.random.nextFloat() >= 0.5f) {
            int lastX = 0;
            int lastY = 0;
            if (stack.hasTag()) {
                CompoundTag compound = stack.getOrCreateTag();
                lastX = compound.getInt("lastX");
                lastY = compound.getInt("lastY");
            }
            boolean change = false;
            if (lastX != 0 && lastX != (int)entity.getX() || lastY != 0 && lastY != (int)entity.getY()) {
                Player player;
                if (!entity.isShiftKeyDown() && entity instanceof Player && this.tryPlaceContainedLiquid(player = (Player)entity, world, player.blockPosition(), true)) {
                    this.checkReplace(player, stack, new ItemStack((ItemLike)Items.BOWL), itemSlot);
                }
                change = true;
            }
            if (change || lastX == 0 || lastY == 0) {
                CompoundTag compound = stack.getOrCreateTag();
                compound.putInt("lastX", (int)entity.getX());
                compound.putInt("lastY", (int)entity.getY());
            }
        }
    }

    private void checkReplace(Player player, ItemStack old, ItemStack stack, int slot) {
        if (player.getInventory().getItem(slot) == old) {
            player.getInventory().setItem(slot, stack);
        } else if (player.getInventory().offhand.get(slot) == old) {
            player.getInventory().offhand.set(slot, (Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    public boolean tryPlaceContainedLiquid(Player player, Level world, BlockPos pos, boolean finite) {
        BlockState state = world.getBlockState(pos);
        boolean nonSolid = !state.isSolid();
        boolean replaceable = state.canBeReplaced();
        if (!(world.isEmptyBlock(pos) || nonSolid || replaceable)) {
            return false;
        }
        if (world.dimensionType().ultraWarm()) {
            world.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.isClientSide && (nonSolid || replaceable) && world.getFluidState(pos).isEmpty()) {
                world.destroyBlock(pos, true);
            }
            world.playSound(player, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState placeState = Blocks.WATER.defaultBlockState();
            world.setBlock(pos, placeState, 3);
        }
        return true;
    }
}

