/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ItemWaterRemovalRing
extends ItemEnergy {
    public ItemWaterRemovalRing() {
        super(800000, 1000);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity player, int itemSlot, boolean isSelected) {
        if (!(player instanceof Player) || player.level().isClientSide || player.isShiftKeyDown()) {
            return;
        }
        ItemStack equipped = ((Player)player).getMainHandItem();
        int energyUse = 150;
        if (StackUtil.isValid(equipped) && equipped == stack && this.getEnergyStored(stack) >= energyUse) {
            int range = 3;
            for (int x = -range; x < range + 1; ++x) {
                for (int z = -range; z < range + 1; ++z) {
                    for (int y = -range; y < range + 1; ++y) {
                        int theZ;
                        int theY;
                        int theX = Mth.floor((double)(player.getX() + (double)x));
                        BlockPos pos = new BlockPos(theX, theY = Mth.floor((double)(player.getY() + (double)y)), theZ = Mth.floor((double)(player.getZ() + (double)z)));
                        Block block = world.getBlockState(pos).getBlock();
                        if (block == Blocks.WATER && this.getEnergyStored(stack) >= energyUse) {
                            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                            if (((Player)player).isCreative()) continue;
                            this.extractEnergyInternal(stack, energyUse, false);
                            continue;
                        }
                        if (block != Blocks.LAVA || this.getEnergyStored(stack) < energyUse * 2) continue;
                        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        if (((Player)player).isCreative()) continue;
                        this.extractEnergyInternal(stack, energyUse * 2, false);
                    }
                }
            }
        }
    }
}

