/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class ItemWingsOfTheBats
extends ItemBase {
    public static final String THE_BAT_BAT = "the bat bat";
    public static final int MAX_FLY_TIME = 800;

    public ItemWingsOfTheBats() {
        super(ActuallyItems.defaultProps().stacksTo(1));
    }

    public static ItemStack getWingItem(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!StackUtil.isValid(player.getInventory().getItem(i)) || !(player.getInventory().getItem(i).getItem() instanceof ItemWingsOfTheBats)) continue;
            return player.getInventory().getItem(i);
        }
        return ItemStack.EMPTY;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return super.getBarColor(stack);
    }

    @SubscribeEvent
    public void onEntityDropEvent(LivingDropsEvent event) {
        Entity source = event.getSource().getEntity();
        if (event.getEntity().level() != null && !event.getEntity().level().isClientSide && source instanceof Player && ConfigBoolValues.DO_BAT_DROPS.isEnabled() && event.getEntity() instanceof Bat) {
            int looting = event.getLootingLevel();
            Iterable equip = source.getHandSlots();
            for (ItemStack stack : equip) {
                if (!StackUtil.isValid(stack) || !THE_BAT_BAT.equalsIgnoreCase(stack.getHoverName().getString()) || !(stack.getItem() instanceof SwordItem)) continue;
                looting += 3;
                break;
            }
            if (event.getEntity().level().random.nextInt(15) <= looting * 2) {
                LivingEntity entityLiving = event.getEntity();
                event.getDrops().add(new ItemEntity(event.getEntity().level(), entityLiving.getX(), entityLiving.getY(), entityLiving.getZ(), new ItemStack((ItemLike)ActuallyItems.BATS_WING.get(), event.getEntity().level().random.nextInt(2 + looting) + 1)));
            }
        }
    }

    @SubscribeEvent
    public void livingUpdateEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
        }
    }
}

