/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.inventory.SackContainer;
import de.ellpeck.actuallyadditions.mod.inventory.VoidSackContainer;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.sack.SackData;
import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class Sack
extends ItemBase {
    public final boolean isVoid;

    public Sack(boolean isVoid) {
        super(ActuallyItems.defaultProps().stacksTo(1));
        this.isVoid = isVoid;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        Level level;
        BlockEntity tile;
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        if (!this.isVoid && (tile = (level = context.getLevel()).getBlockEntity(clickedPos = context.getClickedPos())) != null) {
            if (!context.getLevel().isClientSide) {
                ItemStackHandlerAA inv = new ItemStackHandlerAA(28);
                boolean changed = Optional.ofNullable((IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, clickedPos, (Object)context.getClickedFace())).map(cap -> {
                    boolean localChanged = false;
                    DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, stack);
                    block0: for (int j = 0; j < inv.getSlots(); ++j) {
                        ItemStack invStack = inv.getStackInSlot(j);
                        if (invStack.isEmpty()) continue;
                        for (int i = 0; i < cap.getSlots(); ++i) {
                            ItemStack remain = cap.insertItem(i, invStack, false);
                            if (ItemStack.matches((ItemStack)remain, (ItemStack)invStack)) continue;
                            inv.setStackInSlot(j, remain.copy());
                            localChanged = true;
                            if (remain.isEmpty()) continue block0;
                            invStack = remain;
                        }
                    }
                    return localChanged;
                }).orElse(false);
                if (changed) {
                    DrillItem.writeSlotsToNBT((IItemHandler)inv, stack);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack sackStack = player.getItemInHand(hand);
        if (!world.isClientSide && hand == InteractionHand.MAIN_HAND && sackStack.getItem() instanceof Sack && player instanceof ServerPlayer) {
            if (!this.isVoid) {
                SackData data = Sack.getData(sackStack);
                if (data == null) {
                    return InteractionResultHolder.fail((Object)sackStack);
                }
                UUID uuid = data.getUuid();
                data.updateAccessRecords(player.getName().getString(), System.currentTimeMillis());
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, entity) -> new SackContainer(id, inv, uuid, data.getSpecialHandler()), sackStack.getHoverName()), buffer -> buffer.writeUUID(uuid));
            } else {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, entity) -> new VoidSackContainer(id, inv), sackStack.getHoverName()));
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public static SackData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.getItem() instanceof Sack)) {
            return null;
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("UUID")) {
            uuid = UUID.randomUUID();
            tag.putUUID("UUID", uuid);
        } else {
            uuid = tag.getUUID("UUID");
        }
        return SackManager.get().getOrCreateSack(uuid);
    }
}

