/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.entity.EntityWorm;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.level.BlockEvent;

public class Worm
extends ItemBase {
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        if (level.isClientSide || !EntityWorm.canWormify(level, context.getClickedPos(), state)) {
            return super.useOn(context);
        }
        List worms = level.getEntitiesOfClass(EntityWorm.class, new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 1), (double)(pos.getZ() + 2)));
        if (!worms.isEmpty()) {
            return super.useOn(context);
        }
        EntityWorm worm = new EntityWorm(ActuallyAdditions.ENTITY_WORM.get(), level);
        worm.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        worm.setCustomName(stack.getHoverName());
        level.addFreshEntity((Entity)worm);
        if (!context.getPlayer().isCreative()) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public static void onHoe(BlockEvent.BlockToolModificationEvent event) {
        if (event.getToolAction() == ToolActions.HOE_TILL) {
            BlockState state;
            Level level = event.getPlayer().level();
            if (level.isClientSide || !((Boolean)CommonConfig.Other.WORMS.get()).booleanValue() || event.getResult() == Event.Result.DENY) {
                return;
            }
            BlockPos pos = event.getContext().getClickedPos();
            if (level.isEmptyBlock(pos.above()) && (state = level.getBlockState(pos)).getBlock() == Blocks.GRASS_BLOCK && level.random.nextFloat() >= 0.95f) {
                ItemStack stack = new ItemStack((ItemLike)ActuallyItems.WORM.get(), level.random.nextInt(2) + 1);
                ItemEntity item = new ItemEntity(level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, stack);
                level.addFreshEntity((Entity)item);
            }
        }
    }
}

