/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.material;

import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public enum ArmorMaterials implements ArmorMaterial
{
    QUARTZ("quartz_armor_material", 15, ArmorMaterials.createProtectionMap(3, 5, 6, 3), 8, SoundEvents.ARMOR_EQUIP_GENERIC, 1.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.BLACK_QUARTZ.get()})),
    RESTONIA("restonia_armor_material", 18, ArmorMaterials.createProtectionMap(3, 6, 7, 3), 9, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()})),
    PALIS("palis_armor_material", 10, ArmorMaterials.createProtectionMap(3, 6, 7, 3), 10, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.PALIS_CRYSTAL.get()})),
    DIAMATINE("diamatine_armor_material", 36, ArmorMaterials.createProtectionMap(4, 7, 8, 4), 12, SoundEvents.ARMOR_EQUIP_GENERIC, 3.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get()})),
    VOID("void_armor_material", 23, ArmorMaterials.createProtectionMap(1, 3, 4, 1), 13, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.VOID_CRYSTAL.get()})),
    EMERADIC("emeradic_armor_material", 32, ArmorMaterials.createProtectionMap(6, 9, 9, 4), 18, SoundEvents.ARMOR_EQUIP_GENERIC, 3.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.EMERADIC_CRYSTAL.get()})),
    ENORI("enori_armor_material", 24, ArmorMaterials.createProtectionMap(3, 6, 6, 3), 11, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ActuallyItems.ENORI_CRYSTAL.get()})),
    GOGGLES("goggles_armor_material", 0, ArmorMaterials.createProtectionMap(0, 0, 0, 0), 0, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, () -> Ingredient.EMPTY);

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairMaterial;

    private static EnumMap<ArmorItem.Type, Integer> createProtectionMap(int boots, int leggings, int chest, int helmet) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, boots);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.CHESTPLATE, chest);
            map.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    private ArmorMaterials(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> protectionFunctionForType, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = String.format("%s:%s", "actuallyadditions", name);
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionFunctionForType = protectionFunctionForType;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = new LazyLoadedValue(repairMaterial);
    }

    public int getDurabilityForType(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int getDefenseForType(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public SoundEvent getEquipSound() {
        return this.soundEvent;
    }

    public Ingredient getRepairIngredient() {
        return (Ingredient)this.repairMaterial.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return this.name;
    }

    public float getToughness() {
        return this.toughness;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

