/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.BlockLaserRelay;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LaserRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MethodHandler
implements IMethodHandler {
    @Override
    public boolean addEffectToStack(ItemStack stack, CoffeeIngredient ingredient) {
        MobEffectInstance[] effects;
        boolean worked = false;
        if (ingredient != null && (effects = ingredient.getEffects()) != null && effects.length > 0) {
            for (MobEffectInstance effect : effects) {
                MobEffectInstance effectHas = this.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.getAmplifier() >= ingredient.getMaxAmplifier() - 1) continue;
                    this.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                this.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    @Override
    public boolean addRecipeEffectToStack(ItemStack stack, CoffeeIngredientRecipe ingredient) {
        List<MobEffectInstance> effects;
        boolean worked = false;
        if (ingredient != null && !(effects = ingredient.getEffects()).isEmpty()) {
            for (MobEffectInstance effect : effects) {
                MobEffectInstance effectHas = this.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.getAmplifier() >= ingredient.getMaxAmplifier() - 1) continue;
                    this.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                this.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    @Override
    public MobEffectInstance getSameEffectFromStack(ItemStack stack, MobEffectInstance effect) {
        MobEffectInstance[] effectsStack = this.getEffectsFromStack(stack);
        if (effectsStack != null && effectsStack.length > 0) {
            for (MobEffectInstance effectStack : effectsStack) {
                if (effect.getEffect() != effectStack.getEffect()) continue;
                return effectStack;
            }
        }
        return null;
    }

    @Override
    public void addEffectProperties(ItemStack stack, MobEffectInstance effect, boolean addDur, boolean addAmp) {
        MobEffectInstance[] effects = this.getEffectsFromStack(stack);
        stack.setTag(new CompoundTag());
        for (int i = 0; i < effects.length; ++i) {
            if (effects[i].getEffect() == effect.getEffect()) {
                effects[i] = new MobEffectInstance(effects[i].getEffect(), effects[i].getDuration() + (addDur ? effect.getDuration() : 0), effects[i].getAmplifier() + (addAmp ? (effect.getAmplifier() > 0 ? effect.getAmplifier() : 1) : 0));
            }
            this.addEffectToStack(stack, effects[i]);
        }
    }

    @Override
    public void addEffectToStack(ItemStack stack, MobEffectInstance effect) {
        CompoundTag tag = stack.getOrCreateTag();
        int prevCounter = tag.getInt("Counter");
        CompoundTag compound = new CompoundTag();
        compound.putString("ID", BuiltInRegistries.MOB_EFFECT.getKey((Object)effect.getEffect()).toString());
        compound.putInt("Duration", effect.getDuration());
        compound.putInt("Amplifier", effect.getAmplifier());
        int counter = prevCounter + 1;
        tag.put("" + counter, (Tag)compound);
        tag.putInt("Counter", counter);
        stack.setTag(tag);
    }

    @Override
    public MobEffectInstance[] getEffectsFromStack(ItemStack stack) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        CompoundTag tag = stack.getOrCreateTag();
        for (int counter = tag.getInt("Counter"); counter > 0; --counter) {
            CompoundTag compound = tag.getCompound("" + counter);
            String id = compound.getString("ID");
            ResourceLocation effectID = id.isEmpty() ? new ResourceLocation("speed") : ResourceLocation.tryParse((String)id);
            MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(effectID);
            if (effect == null) {
                ActuallyAdditions.LOGGER.error("Unable to find effect with ID: {}, defaulting to speed", (Object)effectID);
                effect = MobEffects.MOVEMENT_SPEED;
            }
            MobEffectInstance effectInstance = new MobEffectInstance(effect, compound.getInt("Duration"), (int)compound.getByte("Amplifier"));
            effects.add(effectInstance);
        }
        return !effects.isEmpty() ? effects.toArray(new MobEffectInstance[0]) : null;
    }

    @Override
    public boolean invokeConversionLens(BlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        if (hitBlock != null) {
            int range = 1;
            int rangeX = 0;
            int rangeY = 0;
            int rangeZ = 0;
            Direction facing = tile.getOrientation();
            if (facing != Direction.UP && facing != Direction.DOWN) {
                rangeY = range;
                if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                    rangeX = range;
                } else {
                    rangeZ = range;
                }
            } else {
                rangeX = range;
                rangeZ = range;
            }
            for (int reachX = -rangeX; reachX <= rangeX; ++reachX) {
                block1: for (int reachZ = -rangeZ; reachZ <= rangeZ; ++reachZ) {
                    for (int reachY = -rangeY; reachY <= rangeY; ++reachY) {
                        LaserRecipe recipe;
                        ItemStack output;
                        Optional<RecipeHolder<LaserRecipe>> holder;
                        BlockState state;
                        BlockPos pos = new BlockPos(hitBlock.getX() + reachX, hitBlock.getY() + reachY, hitBlock.getZ() + reachZ);
                        if (tile.getWorldObject().isEmptyBlock(pos) || (state = tile.getWorldObject().getBlockState(pos)).getBlock() instanceof BlockLaserRelay || !(holder = LaserRecipe.getRecipeForStack(new ItemStack((ItemLike)state.getBlock()))).isPresent() || tile.getEnergy() < ((LaserRecipe)holder.get().value()).getEnergy() || (output = (recipe = (LaserRecipe)holder.get().value()).getResultItem(tile.getWorldObject().registryAccess()).copy()).isEmpty()) continue;
                        tile.getWorldObject().levelEvent(2001, pos, Block.getId((BlockState)state));
                        if (output.getItem() instanceof BlockItem) {
                            Block toPlace = Block.byItem((Item)output.getItem());
                            BlockState state2Place = toPlace.defaultBlockState();
                            tile.getWorldObject().setBlock(pos, state2Place, 2);
                        } else {
                            ItemEntity item = new ItemEntity(tile.getWorldObject(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, output.copy());
                            tile.getWorldObject().addFreshEntity((Entity)item);
                            tile.getWorldObject().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                        tile.extractEnergy(recipe.getEnergy());
                        continue block1;
                    }
                }
            }
            AABB aabb = new AABB((double)tile.getPosition().getX(), (double)tile.getPosition().getY(), (double)tile.getPosition().getZ(), (double)(hitBlock.getX() + 1), (double)(hitBlock.getY() + 1), (double)(hitBlock.getZ() + 1));
            Vec3i dir = tile.getOrientation().getNormal();
            aabb = aabb.inflate(0.02, 0.02, 0.02).expandTowards((double)dir.getX(), (double)dir.getY(), (double)dir.getZ());
            List items = tile.getWorldObject().getEntitiesOfClass(ItemEntity.class, aabb);
            for (ItemEntity item : items) {
                Optional<RecipeHolder<LaserRecipe>> holder;
                ItemStack stack = item.getItem();
                if (!item.isAlive() || !StackUtil.isValid(stack) || item.getPersistentData().getBoolean("aa_cnv") || !(holder = LaserRecipe.getRecipeForStack(stack)).isPresent()) continue;
                LaserRecipe recipe = (LaserRecipe)holder.get().value();
                int itemsPossible = Math.min(tile.getEnergy() / recipe.getEnergy(), stack.getCount());
                if (itemsPossible <= 0) continue;
                item.discard();
                if (stack.getCount() - itemsPossible > 0) {
                    ItemStack stackCopy = stack.copy();
                    stackCopy.shrink(itemsPossible);
                    ItemEntity inputLeft = new ItemEntity(tile.getWorldObject(), item.getX(), item.getY(), item.getZ(), stackCopy);
                    tile.getWorldObject().addFreshEntity((Entity)inputLeft);
                }
                ItemStack outputCopy = recipe.getResultItem(tile.getWorldObject().registryAccess()).copy();
                outputCopy.setCount(itemsPossible);
                ItemEntity newItem = new ItemEntity(tile.getWorldObject(), item.getX(), item.getY(), item.getZ(), outputCopy);
                newItem.getPersistentData().putBoolean("aa_cnv", true);
                tile.getWorldObject().addFreshEntity((Entity)newItem);
                tile.extractEnergy(recipe.getEnergy() * itemsPossible);
                break;
            }
            return !hitState.isAir();
        }
        return false;
    }

    @Override
    public boolean invokeReconstructor(IAtomicReconstructor tile) {
        if (tile.getEnergy() >= 1000) {
            Direction sideToManipulate = tile.getOrientation();
            Lens currentLens = tile.getLens();
            if (currentLens.canInvoke(tile, sideToManipulate, 1000)) {
                tile.extractEnergy(1000);
                int distance = currentLens.getDistance();
                for (int i = 0; i < distance; ++i) {
                    BlockPos hitBlock = tile.getPosition().relative(sideToManipulate, i + 1);
                    if (!currentLens.invoke(tile.getWorldObject().getBlockState(hitBlock), hitBlock, tile) && i < distance - 1) continue;
                    TileEntityAtomicReconstructor.shootLaser(tile, tile.getWorldObject(), tile.getX(), tile.getY(), tile.getZ(), hitBlock.getX(), hitBlock.getY(), hitBlock.getZ(), currentLens);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addCrusherRecipes(List<ItemStack> inputs, List<ItemStack> outputOnes, int outputOneAmounts, List<ItemStack> outputTwos, int outputTwoAmounts, int outputTwoChance) {
        boolean hasWorkedOnce = false;
        return hasWorkedOnce;
    }

    @Override
    public boolean addCrusherRecipes(List<ItemStack> inputs, ItemStack outputOne, int outputOneAmount, ItemStack outputTwo, int outputTwoAmount, int outputTwoChance) {
        boolean hasWorkedOnce = false;
        return hasWorkedOnce;
    }
}

