/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class CactusFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        Block block;
        Item item;
        int use = 250;
        if (farmer.getEnergy() >= use && (item = seed.getItem()) instanceof BlockItem && (block = Block.byItem((Item)item)) == Blocks.CACTUS) {
            if (block.defaultBlockState().canSurvive((LevelReader)world, pos)) {
                BlockState state = block.defaultBlockState();
                world.setBlock(pos, state, 2);
                world.levelEvent(2001, pos, Block.getId((BlockState)state));
                farmer.extractEnergy(use);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.FAIL;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel serverLevel, BlockPos pos, IFarmer farmer) {
        BlockState state;
        int use = 250;
        if (farmer.getEnergy() >= use && (state = serverLevel.getBlockState(pos)).getBlock() == Blocks.CACTUS) {
            FarmerResult result = FarmerResult.STOP_PROCESSING;
            for (int i = 2; i >= 1; --i) {
                List drops;
                BlockPos up;
                BlockState upState;
                if (farmer.getEnergy() < use || (upState = serverLevel.getBlockState(up = pos.above(i))).getBlock() != Blocks.CACTUS || (drops = state.getDrops(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY))).isEmpty() || !farmer.canAddToOutput(drops)) continue;
                serverLevel.levelEvent(2001, up, Block.getId((BlockState)upState));
                serverLevel.setBlockAndUpdate(up, Blocks.AIR.defaultBlockState());
                farmer.extractEnergy(use);
                farmer.addToOutput(drops);
                result = FarmerResult.SUCCESS;
            }
            return result;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 4;
    }
}

