/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IPlantable;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class DefaultFarmerBehavior
implements IFarmerBehavior {
    private static ItemStack hoe = ItemStack.EMPTY;

    public static boolean defaultPlant(Level world, BlockPos pos, BlockState toPlant, IFarmer farmer, int use) {
        if (toPlant != null) {
            BlockPos farmland = pos.below();
            BlockState farmlandState = world.getBlockState(farmland);
            if (farmlandState.is(BlockTags.DIRT) || farmlandState.is(Blocks.GRASS_BLOCK)) {
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                DefaultFarmerBehavior.useHoeAt(world, farmland);
                world.playSound(null, farmland, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                farmer.extractEnergy(use);
            }
            if (DefaultFarmerBehavior.tryPlant(toPlant, world, pos)) {
                farmer.extractEnergy(use);
                return true;
            }
        }
        return false;
    }

    private static boolean tryPlant(BlockState toPlant, Level world, BlockPos pos) {
        if (toPlant.canSurvive((LevelReader)world, pos)) {
            world.setBlockAndUpdate(pos, toPlant);
            return true;
        }
        return false;
    }

    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        int use = 350;
        if (farmer.getEnergy() >= use * 2 && DefaultFarmerBehavior.defaultPlant(world, pos, this.getPlantablePlantFromStack(seed, world, pos), farmer, use)) {
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel world, BlockPos pos, IFarmer farmer) {
        BlockState state;
        Block block;
        int use = 250;
        if (farmer.getEnergy() >= use && ((block = (state = world.getBlockState(pos)).getBlock()) instanceof CropBlock ? ((CropBlock)block).isMaxAge(state) : state.hasProperty((Property)BlockStateProperties.AGE_7) && (Integer)state.getValue((Property)BlockStateProperties.AGE_7) >= 7 && !(block instanceof StemBlock))) {
            return this.doFarmerStuff(state, world, pos, farmer);
        }
        return FarmerResult.FAIL;
    }

    private FarmerResult doFarmerStuff(BlockState state, ServerLevel serverLevel, BlockPos pos, IFarmer farmer) {
        ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
        ArrayList<ItemStack> other = new ArrayList<ItemStack>();
        List drops = state.getDrops(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY));
        if (drops.isEmpty()) {
            return FarmerResult.FAIL;
        }
        for (ItemStack stack : drops) {
            if (this.getPlantableFromStack(stack) != null) {
                seeds.add(stack);
                continue;
            }
            other.add(stack);
        }
        boolean addSeeds = true;
        if (!farmer.canAddToSeeds(seeds)) {
            other.addAll(seeds);
            addSeeds = false;
        }
        if (farmer.canAddToOutput(other)) {
            farmer.addToOutput(other);
            if (addSeeds) {
                farmer.addToSeeds(seeds);
            }
            serverLevel.levelEvent(2001, pos, Block.getId((BlockState)state));
            serverLevel.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            farmer.extractEnergy(250);
            return FarmerResult.SUCCESS;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private BlockState getPlantablePlantFromStack(ItemStack stack, Level world, BlockPos pos) {
        BlockState state;
        IPlantable plantable;
        if (StackUtil.isValid(stack) && (plantable = this.getPlantableFromStack(stack)) != null && (state = plantable.getPlant((BlockGetter)world, pos)) != null && state.getBlock() instanceof BonemealableBlock) {
            return state;
        }
        return null;
    }

    private IPlantable getPlantableFromStack(ItemStack stack) {
        Block block;
        Item item = stack.getItem();
        if (item instanceof IPlantable) {
            return (IPlantable)item;
        }
        if (item instanceof BlockItem && (block = Block.byItem((Item)item)) instanceof IPlantable) {
            return (IPlantable)block;
        }
        return null;
    }

    private static ItemStack getHoeStack() {
        if (hoe.isEmpty()) {
            hoe = new ItemStack((ItemLike)Items.DIAMOND_HOE);
        }
        return hoe;
    }

    public static InteractionResult useHoeAt(Level world, BlockPos pos) {
        FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        ItemStack itemstack = DefaultFarmerBehavior.getHoeStack();
        if (!player.mayUseItemAt(pos.relative(Direction.UP), Direction.UP, itemstack)) {
            return InteractionResult.FAIL;
        }
        if (world.isEmptyBlock(pos.above())) {
            BlockState state = world.getBlockState(pos);
            if (state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT_PATH)) {
                world.setBlockAndUpdate(pos, Blocks.FARMLAND.defaultBlockState());
                return InteractionResult.SUCCESS;
            }
            if (state.is(BlockTags.DIRT)) {
                world.setBlockAndUpdate(pos, Blocks.FARMLAND.defaultBlockState());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

