/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer.DefaultFarmerBehavior;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class MelonPumpkinFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        int use = 350;
        if (farmer.getEnergy() >= use * 2 && StackUtil.isValid(seed)) {
            boolean isPumpkin;
            Item seedItem = seed.getItem();
            boolean bl = isPumpkin = seedItem == Items.PUMPKIN_SEEDS;
            if (isPumpkin || seedItem == Items.MELON_SEEDS) {
                BlockState toPlant;
                if (pos.getX() % 2 == 0 == (pos.getZ() % 2 == 0) && DefaultFarmerBehavior.defaultPlant(world, pos, toPlant = (isPumpkin ? Blocks.PUMPKIN_STEM : Blocks.MELON_STEM).defaultBlockState(), farmer, use)) {
                    return FarmerResult.SUCCESS;
                }
                return FarmerResult.STOP_PROCESSING;
            }
            return FarmerResult.FAIL;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel world, BlockPos pos, IFarmer farmer) {
        BlockState state;
        Block block;
        int use = 500;
        if (farmer.getEnergy() >= use && ((block = (state = world.getBlockState(pos)).getBlock()) == Blocks.PUMPKIN || block == Blocks.MELON)) {
            List drops = state.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY));
            if (!drops.isEmpty() && farmer.canAddToOutput(drops)) {
                world.levelEvent(2001, pos, Block.getId((BlockState)state));
                world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                farmer.extractEnergy(use);
                farmer.addToOutput(drops);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.STOP_PROCESSING;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

