/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ReedFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, Level world, BlockPos pos, IFarmer farmer) {
        int use = 250;
        if (farmer.getEnergy() >= use && seed.getItem() == Items.SUGAR_CANE) {
            if (Blocks.SUGAR_CANE.defaultBlockState().canSurvive((LevelReader)world, pos)) {
                world.setBlock(pos, Blocks.SUGAR_CANE.defaultBlockState(), 2);
                farmer.extractEnergy(use);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.STOP_PROCESSING;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(ServerLevel world, BlockPos pos, IFarmer farmer) {
        BlockState state;
        int use = 250;
        if (farmer.getEnergy() >= use && (state = world.getBlockState(pos)).getBlock() instanceof SugarCaneBlock) {
            FarmerResult result = FarmerResult.STOP_PROCESSING;
            for (int i = 2; i >= 1; --i) {
                List drops;
                BlockPos up;
                BlockState upState;
                if (farmer.getEnergy() < use || !((upState = world.getBlockState(up = pos.above(i))).getBlock() instanceof SugarCaneBlock) || (drops = state.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY))).isEmpty() || !farmer.canAddToOutput(drops)) continue;
                world.levelEvent(2001, up, Block.getId((BlockState)upState));
                world.setBlockAndUpdate(up, Blocks.AIR.defaultBlockState());
                farmer.extractEnergy(use);
                farmer.addToOutput(drops);
                result = FarmerResult.STOP_PROCESSING;
            }
            return result;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 2;
    }
}

