/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.special;

import de.ellpeck.actuallyadditions.mod.misc.special.RenderSpecial;
import de.ellpeck.actuallyadditions.mod.misc.special.ThreadSpecialFetcher;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;

public class SpecialRenderInit {
    public static final HashMap<String, RenderSpecial> SPECIAL_LIST = new HashMap();

    public SpecialRenderInit() {
        new ThreadSpecialFetcher();
    }

    public static void parse(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            int meta;
            String[] values = properties.getProperty(key).split("@");
            if (values.length <= 0) continue;
            String itemName = values[0];
            try {
                meta = Integer.parseInt(values[1]);
            }
            catch (Exception e) {
                meta = 0;
            }
            ResourceLocation resLoc = new ResourceLocation(itemName.toLowerCase());
            ItemStack stack = SpecialRenderInit.findItem(resLoc);
            if (!StackUtil.isValid(stack)) {
                Object convertedItemName = "";
                for (char c : itemName.toCharArray()) {
                    if (Character.isUpperCase(c)) {
                        convertedItemName = (String)convertedItemName + "_";
                        convertedItemName = (String)convertedItemName + Character.toLowerCase(c);
                        continue;
                    }
                    convertedItemName = (String)convertedItemName + c;
                }
                stack = SpecialRenderInit.findItem(new ResourceLocation((String)convertedItemName));
            }
            if (!StackUtil.isValid(stack)) continue;
            SPECIAL_LIST.put(key.toLowerCase(Locale.ROOT), new RenderSpecial(stack));
        }
    }

    private static ItemStack findItem(ResourceLocation resLoc) {
        Block block;
        if (BuiltInRegistries.ITEM.containsKey(resLoc)) {
            Item item = (Item)BuiltInRegistries.ITEM.get(resLoc);
            if (item != null) {
                return new ItemStack((ItemLike)item);
            }
        } else if (BuiltInRegistries.BLOCK.containsKey(resLoc) && (block = (Block)BuiltInRegistries.BLOCK.get(resLoc)) != null) {
            return new ItemStack((ItemLike)block);
        }
        return ItemStack.EMPTY;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        RenderSpecial render;
        String name;
        String lower;
        if (event.getEntity() != null && SPECIAL_LIST.containsKey(lower = (name = event.getEntity().getName().getString()).toLowerCase(Locale.ROOT)) && (render = SPECIAL_LIST.get(lower)) != null) {
            render.render(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getEntity(), event.getPartialTick());
        }
    }
}

