/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PacketHandlerHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void sendButtonPacket(BlockEntity tile, int buttonId) {
        CompoundTag compound = new CompoundTag();
        BlockPos pos = tile.getBlockPos();
        compound.putInt("X", pos.getX());
        compound.putInt("Y", pos.getY());
        compound.putInt("Z", pos.getZ());
        compound.putString("WorldID", tile.getLevel().dimension().location().toString());
        compound.putInt("PlayerID", Minecraft.getInstance().player.getId());
        compound.putInt("ButtonID", buttonId);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketClientToServer(compound, PacketHandler.GUI_BUTTON_TO_TILE_HANDLER)});
    }

    public static void syncPlayerData(Player player, boolean log) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Log", log);
        CompoundTag data = new CompoundTag();
        PlayerData.getDataFromPlayer(player).writeToNBT(data, false);
        compound.put("Data", (Tag)data);
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).connection.send((CustomPacketPayload)new PacketServerToClient(compound, PacketHandler.SYNC_PLAYER_DATA));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendPlayerDataToServer(boolean log, int type) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Log", log);
        compound.putInt("Type", type);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            compound.putString("World", player.level().dimension().location().toString());
            compound.putUUID("UUID", player.getUUID());
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((Player)player);
            if (type == 0) {
                compound.put("Bookmarks", (Tag)data.saveBookmarks());
            } else if (type == 1) {
                compound.putBoolean("DidBookTutorial", data.didBookTutorial);
            } else if (type == 2) {
                compound.put("Trials", (Tag)data.saveTrials());
                int total = 0;
                for (IBookletChapter iBookletChapter : ActuallyAdditionsAPI.entryTrials.getAllChapters()) {
                }
                if (data.completedTrials.size() >= total) {
                    compound.putBoolean("Achievement", true);
                }
            }
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketClientToServer(compound, PacketHandler.PLAYER_DATA_TO_SERVER)});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendNumberPacket(BlockEntity tile, double number, int id) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("X", tile.getBlockPos().getX());
        compound.putInt("Y", tile.getBlockPos().getY());
        compound.putInt("Z", tile.getBlockPos().getZ());
        compound.putString("WorldID", tile.getLevel().dimension().location().toString());
        compound.putInt("PlayerID", Minecraft.getInstance().player.getId());
        compound.putInt("NumberID", id);
        compound.putDouble("Number", number);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketClientToServer(compound, PacketHandler.GUI_NUMBER_TO_TILE_HANDLER)});
    }
}

