/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.network.IDataHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.commons.lang3.tuple.Pair;

public record PacketServerToClient(CompoundTag data, IDataHandler handler) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("actuallyadditions", "server_to_client");

    public PacketServerToClient(Pair<CompoundTag, IDataHandler> data) {
        this((CompoundTag)data.getLeft(), (IDataHandler)data.getRight());
    }

    public PacketServerToClient(FriendlyByteBuf buffer) {
        this(PacketServerToClient.fromBytes(buffer));
    }

    public static Pair<CompoundTag, IDataHandler> fromBytes(FriendlyByteBuf buffer) {
        try {
            CompoundTag data = buffer.readNbt();
            int handlerId = buffer.readInt();
            if (handlerId >= 0 && handlerId < PacketHandler.DATA_HANDLERS.size()) {
                return Pair.of((Object)data, (Object)PacketHandler.DATA_HANDLERS.get(handlerId));
            }
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.error("Something went wrong trying to receive a client packet!", (Throwable)e);
        }
        return Pair.of(null, null);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.data);
        buf.writeInt(PacketHandler.DATA_HANDLERS.indexOf(this.handler));
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketServerToClient message, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            if (message.data != null && message.handler != null) {
                message.handler.handleData(message.data, context);
            }
        });
    }
}

