/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.sack;

import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class SackData {
    public static final int SIZE = 28;
    private final UUID uuid;
    private final ItemStackHandlerAA inventory;
    private final Optional<IItemHandler> optional;
    public final Metadata meta = new Metadata();

    public Optional<IItemHandler> getOptional() {
        return this.optional;
    }

    public IItemHandler getHandler() {
        return this.inventory;
    }

    public ItemStackHandlerAA getSpecialHandler() {
        return this.inventory;
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public SackData(UUID uuid) {
        this.uuid = uuid;
        this.inventory = new ItemStackHandlerAA(28){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SackManager.get().setDirty();
            }
        };
        this.optional = Optional.ofNullable(this.inventory);
    }

    public SackData(UUID uuid, CompoundTag incoming) {
        this.uuid = uuid;
        this.inventory = new ItemStackHandlerAA(28){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SackManager.get().setDirty();
            }
        };
        this.inventory.deserializeNBT(incoming.getCompound("Inventory"));
        this.optional = Optional.ofNullable(this.inventory);
        if (incoming.contains("Metadata")) {
            this.meta.deserializeNBT(incoming.getCompound("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static Optional<SackData> fromNBT(CompoundTag nbt) {
        if (nbt.contains("UUID")) {
            UUID uuid = nbt.getUUID("UUID");
            return Optional.of(new SackData(uuid, nbt));
        }
        return Optional.empty();
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("UUID", this.uuid);
        nbt.put("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.put("Metadata", (Tag)this.meta.serializeNBT());
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundTag> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("firstPlayer", this.firstAccessedPlayer);
            nbt.putLong("firstTime", this.firstAccessedTime);
            nbt.putString("lastPlayer", this.lastAccessedPlayer);
            nbt.putLong("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.firstAccessedPlayer = nbt.getString("firstPlayer");
            this.firstAccessedTime = nbt.getLong("firstTime");
            this.lastAccessedPlayer = nbt.getString("lastPlayer");
            this.lastAccessedTime = nbt.getLong("lastTime");
        }
    }
}

