/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.PressingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.SingleItem;
import de.ellpeck.actuallyadditions.mod.fluids.OutputOnlyFluidTank;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCanolaPress;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityCanolaPress
extends TileEntityInventoryBase
implements MenuProvider,
ISharingFluidHandler {
    public static final int ENERGY_USE = 35;
    private static final int TIME = 30;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(40000, 100, 0);
    public final OutputOnlyFluidTank tank = new OutputOnlyFluidTank(2000);
    public int currentProcessTime;
    private int lastEnergyStored;
    private int lastTankAmount;
    private int lastProcessTime;

    public TileEntityCanolaPress(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.CANOLA_PRESS.getTileEntityType(), pos, state, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTankScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProcessScaled(int i) {
        return this.currentProcessTime * i / 30;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("ProcessTime", this.currentProcessTime);
        }
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentProcessTime = compound.getInt("ProcessTime");
        }
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCanolaPress) {
            TileEntityCanolaPress tile = (TileEntityCanolaPress)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCanolaPress) {
            TileEntityCanolaPress tile = (TileEntityCanolaPress)t;
            tile.serverTick();
            Optional<RecipeHolder<PressingRecipe>> recipe = TileEntityCanolaPress.getRecipeForInput(tile.inv.getStackInSlot(0));
            recipe.ifPresent(h -> {
                PressingRecipe r = (PressingRecipe)h.value();
                if ((r.getOutput().isFluidEqual(tile.tank.getFluid()) || tile.tank.isEmpty()) && r.getOutput().getAmount() <= tile.tank.getCapacity() - tile.tank.getFluidAmount() && tile.storage.getEnergyStored() >= 35) {
                    ++tile.currentProcessTime;
                    tile.storage.extractEnergyInternal(35, false);
                    if (tile.currentProcessTime >= 30) {
                        tile.currentProcessTime = 0;
                        tile.inv.setStackInSlot(0, StackUtil.shrink(tile.inv.getStackInSlot(0), 1));
                        FluidStack produced = r.getOutput().copy();
                        tile.tank.fillInternal(produced, IFluidHandler.FluidAction.EXECUTE);
                        tile.setChanged();
                    }
                }
            });
            if (!recipe.isPresent()) {
                tile.currentProcessTime = 0;
            }
            if ((tile.storage.getEnergyStored() != tile.lastEnergyStored || tile.tank.getFluidAmount() != tile.lastTankAmount | tile.currentProcessTime != tile.lastProcessTime) && tile.sendUpdateWithInterval()) {
                tile.lastEnergyStored = tile.storage.getEnergyStored();
                tile.lastProcessTime = tile.currentProcessTime;
                tile.lastTankAmount = tile.tank.getFluidAmount();
            }
        }
    }

    public boolean validInput(ItemStack stack) {
        return TileEntityCanolaPress.getRecipeForInput(stack).isPresent();
    }

    public static Optional<RecipeHolder<PressingRecipe>> getRecipeForInput(ItemStack stack) {
        return ActuallyAdditionsAPI.PRESSING_RECIPES.stream().filter(recipe -> ((PressingRecipe)recipe.value()).matches(new SingleItem(stack), null)).findFirst();
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> slot == 0 && this.validInput(stack);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation;
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        return this.tank;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return this.tank.getFluidAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.canola_press");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new ContainerCanolaPress(windowId, playerInventory, this);
    }
}

