/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.CrusherContainer;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPoweredFurnace;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityCrusher
extends TileEntityInventoryBase
implements IButtonReactor,
MenuProvider {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1_1 = 1;
    public static final int SLOT_OUTPUT_1_2 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_OUTPUT_2_1 = 4;
    public static final int SLOT_OUTPUT_2_2 = 5;
    public static final int ENERGY_USE = 40;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(60000, 100, 0);
    public int firstCrushTime;
    public int secondCrushTime;
    public boolean isDouble;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstCrush;
    private int lastSecondCrush;
    private boolean lastAutoSplit;
    private boolean lastCrushed;

    public TileEntityCrusher(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state, slots);
    }

    public TileEntityCrusher(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.CRUSHER.getTileEntityType(), pos, state, 3);
        this.isDouble = false;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("FirstCrushTime", this.firstCrushTime);
            compound.putInt("SecondCrushTime", this.secondCrushTime);
            compound.putBoolean("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstCrushTime = compound.getInt("FirstCrushTime");
            this.secondCrushTime = compound.getInt("SecondCrushTime");
            this.isAutoSplit = compound.getBoolean("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        boolean current;
        super.serverTick();
        if (this.isDouble && this.isAutoSplit) {
            TileEntityPoweredFurnace.autoSplit(this.inv, 0, 3);
        }
        boolean crushed = false;
        boolean canCrushOnFirst = this.canCrushOn(0, 1, 2);
        boolean canCrushOnSecond = false;
        if (this.isDouble) {
            canCrushOnSecond = this.canCrushOn(3, 4, 5);
        }
        boolean shouldPlaySound = false;
        if (canCrushOnFirst) {
            if (this.storage.getEnergyStored() >= 40) {
                if (this.firstCrushTime % 20 == 0) {
                    shouldPlaySound = true;
                }
                ++this.firstCrushTime;
                if (this.firstCrushTime >= this.getMaxCrushTime()) {
                    this.finishCrushing(0, 1, 2);
                    this.firstCrushTime = 0;
                }
                this.storage.extractEnergyInternal(40, false);
            }
            crushed = this.storage.getEnergyStored() >= 40;
        } else {
            this.firstCrushTime = 0;
        }
        if (this.isDouble) {
            if (canCrushOnSecond) {
                if (this.storage.getEnergyStored() >= 40) {
                    if (this.secondCrushTime % 20 == 0) {
                        shouldPlaySound = true;
                    }
                    ++this.secondCrushTime;
                    if (this.secondCrushTime >= this.getMaxCrushTime()) {
                        this.finishCrushing(3, 4, 5);
                        this.secondCrushTime = 0;
                    }
                    this.storage.extractEnergyInternal(40, false);
                }
                crushed = this.storage.getEnergyStored() >= 40;
            } else {
                this.secondCrushTime = 0;
            }
        }
        boolean changeTo = current = ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue();
        if (this.lastCrushed != crushed) {
            changeTo = crushed;
        }
        if (this.isRedstonePowered) {
            changeTo = true;
        }
        if (!crushed && !this.isRedstonePowered) {
            changeTo = false;
        }
        if (changeTo != current) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(changeTo)));
        }
        this.lastCrushed = crushed;
        if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstCrush != this.firstCrushTime || this.lastSecondCrush != this.secondCrushTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
            this.lastEnergy = this.storage.getEnergyStored();
            this.lastFirstCrush = this.firstCrushTime;
            this.lastSecondCrush = this.secondCrushTime;
            this.lastAutoSplit = this.isAutoSplit;
        }
        if (shouldPlaySound) {
            this.level.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)AASounds.CRUSHER.get(), SoundSource.BLOCKS, 0.025f, 1.0f);
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot == 0 || slot == 3;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 2 || slot == 4 || slot == 5;
    }

    public static Optional<RecipeHolder<CrushingRecipe>> getRecipeForInput(ItemStack itemStack) {
        return ActuallyAdditionsAPI.CRUSHER_RECIPES.stream().filter($ -> ((CrushingRecipe)$.value()).matches(itemStack)).findFirst();
    }

    public boolean canCrushOn(int theInput, int theFirstOutput, int theSecondOutput) {
        ItemStack inputStack = this.inv.getStackInSlot(theInput);
        if (!inputStack.isEmpty()) {
            Optional<RecipeHolder<CrushingRecipe>> recipeOpt = TileEntityCrusher.getRecipeForInput(inputStack);
            if (recipeOpt.isEmpty()) {
                return false;
            }
            CrushingRecipe recipe = (CrushingRecipe)recipeOpt.get().value();
            ItemStack outputOne = recipe.getOutputOne();
            ItemStack outputTwo = recipe.getOutputTwo();
            if (!outputOne.isEmpty()) {
                return (this.inv.getStackInSlot(theFirstOutput).isEmpty() || ItemStack.isSameItem((ItemStack)this.inv.getStackInSlot(theFirstOutput), (ItemStack)outputOne) && this.inv.getStackInSlot(theFirstOutput).getCount() <= this.inv.getStackInSlot(theFirstOutput).getMaxStackSize() - outputOne.getCount()) && (outputTwo.isEmpty() || this.inv.getStackInSlot(theSecondOutput).isEmpty() || ItemStack.isSameItem((ItemStack)this.inv.getStackInSlot(theSecondOutput), (ItemStack)outputTwo) && this.inv.getStackInSlot(theSecondOutput).getCount() <= this.inv.getStackInSlot(theSecondOutput).getMaxStackSize() - outputTwo.getCount());
            }
        }
        return false;
    }

    private int getMaxCrushTime() {
        return this.isDouble ? 150 : 100;
    }

    public void finishCrushing(int theInput, int theFirstOutput, int theSecondOutput) {
        float rand;
        ItemStack outputTwo;
        Optional<RecipeHolder<CrushingRecipe>> recipeOpt = TileEntityCrusher.getRecipeForInput(this.inv.getStackInSlot(theInput));
        if (recipeOpt.isEmpty()) {
            return;
        }
        CrushingRecipe recipe = (CrushingRecipe)recipeOpt.get().value();
        ItemStack outputOne = recipe.getOutputOne();
        if (!outputOne.isEmpty()) {
            if (this.inv.getStackInSlot(theFirstOutput).isEmpty()) {
                this.inv.setStackInSlot(theFirstOutput, outputOne.copy());
            } else if (this.inv.getStackInSlot(theFirstOutput).getItem() == outputOne.getItem()) {
                this.inv.setStackInSlot(theFirstOutput, StackUtil.grow(this.inv.getStackInSlot(theFirstOutput), outputOne.getCount()));
            }
        }
        if (!(outputTwo = recipe.getOutputTwo()).isEmpty() && (rand = this.level.random.nextFloat()) <= recipe.getSecondChance()) {
            if (this.inv.getStackInSlot(theSecondOutput).isEmpty()) {
                this.inv.setStackInSlot(theSecondOutput, outputTwo.copy());
            } else if (this.inv.getStackInSlot(theSecondOutput).getItem() == outputTwo.getItem()) {
                this.inv.setStackInSlot(theSecondOutput, StackUtil.grow(this.inv.getStackInSlot(theSecondOutput), outputTwo.getCount()));
            }
        }
        this.inv.getStackInSlot(theInput).shrink(1);
    }

    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public int getFirstTimeToScale(int i) {
        return this.firstCrushTime * i / this.getMaxCrushTime();
    }

    public int getSecondTimeToScale(int i) {
        return this.secondCrushTime * i / this.getMaxCrushTime();
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.setChanged();
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.crusher");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new CrusherContainer(windowId, playerInventory, this);
    }
}

