/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFeeder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityFeeder
extends TileEntityInventoryBase
implements MenuProvider {
    public static final int THRESHOLD = 30;
    private static final int TIME = 100;
    public int currentTimer;
    public int currentAnimalAmount;
    private int lastAnimalAmount;
    private int lastTimer;

    public TileEntityFeeder(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FEEDER.getTileEntityType(), pos, state, 1);
    }

    public int getCurrentTimerToScale(int i) {
        return this.currentTimer * i / 100;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        compound.putInt("Timer", this.currentTimer);
        if (type == TileEntityBase.NBTType.SYNC) {
            compound.putInt("Animals", this.currentAnimalAmount);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.currentTimer = compound.getInt("Timer");
        if (type == TileEntityBase.NBTType.SYNC) {
            this.currentAnimalAmount = compound.getInt("Animals");
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFeeder) {
            TileEntityFeeder tile = (TileEntityFeeder)t;
            tile.clientTick();
            tile.currentTimer = Mth.clamp((int)(++tile.currentTimer), (int)0, (int)100);
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFeeder) {
            TileEntityFeeder tile = (TileEntityFeeder)t;
            tile.serverTick();
            tile.currentTimer = Mth.clamp((int)(++tile.currentTimer), (int)0, (int)100);
            int range = 5;
            ItemStack stack = tile.inv.getStackInSlot(0);
            if (!stack.isEmpty() && tile.currentTimer >= 100) {
                Optional<Animal> opt;
                List animals = level.getEntitiesOfClass(Animal.class, new AABB(pos).inflate((double)range));
                tile.currentAnimalAmount = animals.size();
                if (tile.currentAnimalAmount >= 2 && tile.currentAnimalAmount < 30 && (opt = animals.stream().filter(e -> tile.canBeFed(stack, (Animal)e)).findAny()).isPresent()) {
                    tile.feedAnimal(opt.get());
                    stack.shrink(1);
                    tile.currentTimer = 0;
                    tile.setChanged();
                }
            }
            if ((tile.lastAnimalAmount != tile.currentAnimalAmount || tile.lastTimer != tile.currentTimer) && tile.sendUpdateWithInterval()) {
                tile.lastAnimalAmount = tile.currentAnimalAmount;
                tile.lastTimer = tile.currentTimer;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation;
    }

    private void feedAnimal(Animal animal) {
        animal.setInLove(null);
        for (int i = 0; i < 7; ++i) {
            double d = animal.level().random.nextGaussian() * 0.02;
            double d1 = animal.level().random.nextGaussian() * 0.02;
            double d2 = animal.level().random.nextGaussian() * 0.02;
            animal.level().addParticle((ParticleOptions)ParticleTypes.HEART, animal.getX() + (double)(animal.level().random.nextFloat() * animal.getBbWidth() * 2.0f) - (double)animal.getBbWidth(), animal.getY() + 0.5 + (double)(animal.level().random.nextFloat() * animal.getBbHeight()), animal.getZ() + (double)(animal.level().random.nextFloat() * animal.getBbWidth() * 2.0f) - (double)animal.getBbWidth(), d, d1, d2);
        }
    }

    private boolean canBeFed(ItemStack stack, Animal animal) {
        if (animal instanceof Horse && ((Horse)animal).isTamed()) {
            Item item = stack.getItem();
            return animal.getAge() == 0 && !animal.isInLove() && (item == Items.GOLDEN_APPLE || item == Items.GOLDEN_CARROT);
        }
        return animal.getAge() == 0 && !animal.isInLove() && animal.isFood(stack);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.feeder");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player p_createMenu_3_) {
        return new ContainerFeeder(windowId, playerInventory, this);
    }
}

