/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFireworkBox;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityFireworkBox
extends TileEntityBase
implements IEnergyDisplay,
INumberReactor,
MenuProvider {
    public static final int USE_PER_SHOT = 500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(20000, 200, 0);
    public int intValuePlay = 2;
    public int chargeAmount = 2;
    public int flightTime = 2;
    public float trailOrFlickerChance = 0.65f;
    public float flickerChance = 0.25f;
    public int colorAmount = 3;
    public float typeChance0 = 1.0f;
    public float typeChance1 = 0.0f;
    public float typeChance2 = 0.0f;
    public float typeChance3 = 0.0f;
    public float typeChance4 = 0.0f;
    public int areaOfEffect = 2;
    private int timeUntilNextFirework;
    private int oldEnergy;

    public TileEntityFireworkBox(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.FIREWORK_BOX.getTileEntityType(), pos, state);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("Play", this.intValuePlay);
            compound.putInt("ChargeAmount", this.chargeAmount);
            compound.putInt("FlightTime", this.flightTime);
            compound.putFloat("TrailFlickerChance", this.trailOrFlickerChance);
            compound.putFloat("FlickerChance", this.flickerChance);
            compound.putInt("ColorAmount", this.colorAmount);
            compound.putFloat("TypeChance0", this.typeChance0);
            compound.putFloat("TypeChance1", this.typeChance1);
            compound.putFloat("TypeChance2", this.typeChance2);
            compound.putFloat("TypeChance3", this.typeChance3);
            compound.putFloat("TypeChance4", this.typeChance4);
            compound.putInt("Area", this.areaOfEffect);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.intValuePlay = compound.getInt("Play");
            this.chargeAmount = compound.getInt("ChargeAmount");
            this.flightTime = compound.getInt("FlightTime");
            this.trailOrFlickerChance = compound.getFloat("TrailFlickerChance");
            this.flickerChance = compound.getFloat("FlickerChance");
            this.colorAmount = compound.getInt("ColorAmount");
            this.typeChance0 = compound.getFloat("TypeChance0");
            this.typeChance1 = compound.getFloat("TypeChance1");
            this.typeChance2 = compound.getFloat("TypeChance2");
            this.typeChance3 = compound.getFloat("TypeChance3");
            this.typeChance4 = compound.getFloat("TypeChance4");
            this.areaOfEffect = compound.getInt("Area");
        }
    }

    @Override
    public void onNumberReceived(double number, int id, Player player) {
        switch (id) {
            case 0: {
                this.intValuePlay = (int)number;
                break;
            }
            case 1: {
                this.chargeAmount = (int)number;
                break;
            }
            case 2: {
                this.flightTime = (int)number;
                break;
            }
            case 3: {
                this.trailOrFlickerChance = (float)number;
                break;
            }
            case 4: {
                this.flickerChance = (float)number;
                break;
            }
            case 5: {
                this.colorAmount = (int)number;
                break;
            }
            case 6: {
                this.typeChance0 = (float)number;
                break;
            }
            case 7: {
                this.typeChance1 = (float)number;
                break;
            }
            case 8: {
                this.typeChance2 = (float)number;
                break;
            }
            case 9: {
                this.typeChance3 = (float)number;
                break;
            }
            case 10: {
                this.typeChance4 = (float)number;
                break;
            }
            case 11: {
                this.areaOfEffect = (int)number;
            }
        }
        this.setChanged();
        this.sendUpdate();
    }

    public void spawnFireworks(Level world, double x, double y, double z) {
        double newZ;
        ItemStack firework = this.makeFirework();
        double newX = x + this.getRandomAoe();
        if (world.hasChunkAt(BlockPos.containing((double)newX, (double)y, (double)(newZ = z + this.getRandomAoe())))) {
            FireworkRocketEntity rocket = new FireworkRocketEntity(world, newX, y + 1.0, newZ, firework);
            world.addFreshEntity((Entity)rocket);
        }
    }

    private double getRandomAoe() {
        if (this.areaOfEffect <= 0) {
            return 0.5;
        }
        return Mth.nextDouble((RandomSource)this.level.random, (double)0.0, (double)(this.areaOfEffect * 2)) - (double)this.areaOfEffect;
    }

    private ItemStack makeFirework() {
        ListTag list = new ListTag();
        for (int i = 0; i < this.getRandomWithPlay(this.chargeAmount); ++i) {
            list.add((Object)this.makeFireworkCharge());
        }
        CompoundTag compound1 = new CompoundTag();
        compound1.put("Explosions", (Tag)list);
        compound1.putByte("Flight", (byte)this.getRandomWithPlay(this.flightTime));
        CompoundTag compound = new CompoundTag();
        compound.put("Fireworks", (Tag)compound1);
        ItemStack firework = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        firework.setTag(compound);
        return firework;
    }

    private CompoundTag makeFireworkCharge() {
        CompoundTag compound = new CompoundTag();
        if (this.level.random.nextFloat() <= this.trailOrFlickerChance) {
            if (this.level.random.nextFloat() <= this.flickerChance) {
                compound.putBoolean("Flicker", true);
            } else {
                compound.putBoolean("Trail", true);
            }
        }
        int[] colors = new int[this.getRandomWithPlay(this.colorAmount)];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DyeColor.values()[this.level.random.nextInt(DyeColor.values().length)].getFireworkColor();
        }
        compound.putIntArray("Colors", colors);
        compound.putByte("Type", (byte)this.getRandomType());
        return compound;
    }

    private int getRandomWithPlay(int value) {
        return Mth.clamp((int)Mth.nextInt((RandomSource)this.level.random, (int)(value - this.intValuePlay), (int)(value + this.intValuePlay)), (int)1, (int)6);
    }

    private int getRandomType() {
        ArrayList<WeightedFireworkType> possible = new ArrayList<WeightedFireworkType>();
        possible.add(new WeightedFireworkType(0, this.typeChance0));
        possible.add(new WeightedFireworkType(1, this.typeChance1));
        possible.add(new WeightedFireworkType(2, this.typeChance2));
        possible.add(new WeightedFireworkType(3, this.typeChance3));
        possible.add(new WeightedFireworkType(4, this.typeChance4));
        int weight = WeightedRandom.getTotalWeight(possible);
        if (weight <= 0) {
            return 0;
        }
        return WeightedRandom.getRandomItem((RandomSource)this.level.random, possible, (int)weight).map(weightedFireworkType -> weightedFireworkType.type).orElse(0);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFireworkBox) {
            TileEntityFireworkBox tile = (TileEntityFireworkBox)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFireworkBox) {
            TileEntityFireworkBox tile = (TileEntityFireworkBox)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && !tile.isPulseMode) {
                if (tile.timeUntilNextFirework > 0) {
                    --tile.timeUntilNextFirework;
                    if (tile.timeUntilNextFirework <= 0) {
                        tile.doWork();
                    }
                } else {
                    tile.timeUntilNextFirework = 100;
                }
            }
            if (tile.oldEnergy != tile.storage.getEnergyStored() && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 500) {
            this.spawnFireworks(this.level, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
            this.storage.extractEnergyInternal(500, false);
        }
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.fireworkBox");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player p_createMenu_3_) {
        return new ContainerFireworkBox(windowId, playerInventory, this);
    }

    private static class WeightedFireworkType
    implements WeightedEntry {
        public final int type;
        public final Weight chance;

        public WeightedFireworkType(int type, float chance) {
            this.type = type;
            this.chance = Weight.of((int)((int)(chance * 100.0f)));
        }

        public Weight getWeight() {
            return this.chance;
        }
    }
}

