/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.fluids.AATank;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFluidCollector;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityFluidCollector
extends TileEntityBase
implements ISharingFluidHandler,
MenuProvider {
    public boolean isPlacer;
    public final AATank tank = new AATank(8000){

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!TileEntityFluidCollector.this.isPlacer) {
                return 0;
            }
            return super.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (TileEntityFluidCollector.this.isPlacer) {
                return FluidStack.EMPTY;
            }
            return super.drain(maxDrain, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (TileEntityFluidCollector.this.isPlacer) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }
    };
    private int lastTankAmount;
    private int currentTime;
    private int lastCompare;

    public TileEntityFluidCollector(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileEntityFluidCollector(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.FLUID_COLLECTOR.getTileEntityType(), pos, state);
        this.isPlacer = false;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    private void doWork() {
        FluidStack stack;
        Block fluid;
        BlockState state = this.level.getBlockState(this.worldPosition);
        Direction sideToManipulate = WorldUtil.getDirectionByPistonRotation(state);
        BlockPos coordsBlock = this.worldPosition.relative(sideToManipulate);
        BlockState stateToBreak = this.level.getBlockState(coordsBlock);
        Block blockToBreak = stateToBreak.getBlock();
        if (!this.isPlacer && 1000 <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
            if (blockToBreak instanceof LiquidBlock && stateToBreak.getFluidState().isSource() && ((LiquidBlock)blockToBreak).getFluid() != null && this.tank.fillInternal(new FluidStack((Fluid)((LiquidBlock)blockToBreak).getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) >= 1000) {
                this.tank.fillInternal(new FluidStack((Fluid)((LiquidBlock)blockToBreak).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                this.level.setBlockAndUpdate(coordsBlock, Blocks.AIR.defaultBlockState());
            }
        } else if (this.isPlacer && blockToBreak.defaultBlockState().canBeReplaced() && this.tank.getFluidAmount() >= 1000 && (fluid = (stack = this.tank.getFluid()).getFluid().defaultFluidState().createLegacyBlock().getBlock()) != null) {
            boolean placeable;
            BlockPos offsetPos = this.worldPosition.relative(sideToManipulate);
            boolean bl = placeable = !stateToBreak.getFluidState().isSource() && blockToBreak.defaultBlockState().canBeReplaced();
            if (placeable) {
                this.tank.drainInternal(1000, IFluidHandler.FluidAction.EXECUTE);
                if (this.level.dimensionType().ultraWarm() && stack.getFluid().is(FluidTags.WATER)) {
                    this.level.playSound(null, offsetPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.8f);
                    if (this.level instanceof ServerLevel) {
                        for (int l = 0; l < 8; ++l) {
                            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)offsetPos.getX() + Math.random(), (double)offsetPos.getY() + Math.random(), (double)offsetPos.getZ() + Math.random(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else {
                    this.level.setBlock(offsetPos, fluid.defaultBlockState(), 3);
                }
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 15.0f;
        return (int)calc;
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        return this.tank;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("CurrentTime", this.currentTime);
        }
        this.tank.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.getInt("CurrentTime");
        }
        this.tank.readFromNBT(compound);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFluidCollector) {
            TileEntityFluidCollector tile = (TileEntityFluidCollector)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityFluidCollector) {
            TileEntityFluidCollector tile = (TileEntityFluidCollector)t;
            tile.serverTick();
        }
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        if (!this.isRedstonePowered && !this.isPulseMode) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 15;
            }
        }
        if (this.lastCompare != this.getComparatorStrength()) {
            this.lastCompare = this.getComparatorStrength();
            this.setChanged();
        }
        if (this.lastTankAmount != this.tank.getFluidAmount() && this.sendUpdateWithInterval()) {
            this.lastTankAmount = this.tank.getFluidAmount();
        }
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return this.tank.getFluidAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return !this.isPlacer;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return Direction.values();
    }

    public Component getDisplayName() {
        return Component.translatable((String)(this.isPlacer ? "container.actuallyadditions.fluidPlacer" : "container.actuallyadditions.fluidCollector"));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new ContainerFluidCollector(windowId, playerInventory, this);
    }
}

