/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;

public class TileEntityPlayerInterface
extends TileEntityBase
implements IEnergyDisplay {
    public static final int DEFAULT_RANGE = 32;
    private final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 50, 0);
    public UUID connectedPlayer;
    public String playerName;
    private IItemHandler playerHandler;
    private Player oldPlayer;
    private int oldEnergy;
    private int range;

    public TileEntityPlayerInterface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PLAYER_INTERFACE.getTileEntityType(), pos, state);
    }

    private Player getPlayer() {
        Player player;
        if (this.connectedPlayer != null && this.level != null && (player = this.level.getPlayerByUUID(this.connectedPlayer)) != null && player.distanceToSqr((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()) <= (double)this.range) {
            return player;
        }
        return null;
    }

    @Override
    public IItemHandler getItemHandler(Direction facing) {
        Player player = this.getPlayer();
        if (this.oldPlayer != player) {
            this.oldPlayer = player;
            this.playerHandler = player == null ? null : new PlayerInvWrapper(player.getInventory());
            this.invalidateCapabilities();
        }
        return this.playerHandler;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface tile = (TileEntityPlayerInterface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface tile = (TileEntityPlayerInterface)t;
            tile.serverTick();
            boolean changed = false;
            tile.range = TileEntityPhantomface.upgradeRange(32, level, pos);
            Player player = tile.getPlayer();
            if (player != null) {
                for (int i = 0; i < player.getInventory().getContainerSize() && tile.storage.getEnergyStored() > 0; ++i) {
                    int received;
                    ItemStack slot = player.getInventory().getItem(i);
                    if (slot.isEmpty() || slot.getCount() != 1 || (received = Optional.ofNullable((IEnergyStorage)slot.getCapability(Capabilities.EnergyStorage.ITEM)).map(cap -> cap.receiveEnergy(tile.storage.getEnergyStored(), false)).orElse(0).intValue()) <= 0) continue;
                    tile.storage.extractEnergyInternal(received, false);
                }
            }
            if (changed) {
                tile.setChanged();
                tile.sendUpdate();
            }
            if (tile.storage.getEnergyStored() != tile.oldEnergy && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (this.connectedPlayer != null && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putUUID("Player", this.connectedPlayer);
            compound.putString("PlayerName", this.playerName);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (compound.contains("Player") && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.connectedPlayer = compound.getUUID("Player");
            this.playerName = compound.getString("PlayerName");
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }
}

