/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerMiner;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.IFluidBlock;

public class TileEntityVerticalDigger
extends TileEntityInventoryBase
implements IButtonReactor,
IEnergyDisplay,
MenuProvider {
    public static final int ENERGY_USE_PER_BLOCK = 650;
    public static final int DEFAULT_RANGE = 2;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(200000, 2000, 0);
    public boolean onlyMineOres;
    public int checkX;
    public int checkY = -1;
    public int checkZ;
    private int oldEnergy;
    private int oldCheckX;
    private int oldCheckY;
    private int oldCheckZ;

    public TileEntityVerticalDigger(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.VERTICAL_DIGGER.getTileEntityType(), pos, state, 9);
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("CheckX", this.checkX);
            compound.putInt("CheckY", this.checkY);
            compound.putInt("CheckZ", this.checkZ);
        }
        if (type != TileEntityBase.NBTType.SAVE_BLOCK || this.onlyMineOres) {
            compound.putBoolean("OnlyOres", this.onlyMineOres);
        }
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.checkX = compound.getInt("CheckX");
            this.checkY = compound.getInt("CheckY");
            this.checkZ = compound.getInt("CheckZ");
        }
        this.onlyMineOres = compound.getBoolean("OnlyOres");
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityVerticalDigger) {
            TileEntityVerticalDigger tile = (TileEntityVerticalDigger)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityVerticalDigger) {
            TileEntityVerticalDigger tile = (TileEntityVerticalDigger)t;
            tile.serverTick();
            if (!tile.isRedstonePowered && tile.ticksElapsed % 5 == 0 && tile.checkY != 0) {
                int range = TileEntityPhantomface.upgradeRange(2, level, pos);
                if (tile.checkY < 0) {
                    tile.checkY = tile.worldPosition.getY() - 1;
                    tile.checkX = -range;
                    tile.checkZ = -range;
                }
                if (tile.checkY > 0 && tile.mine()) {
                    ++tile.checkX;
                    if (tile.checkX > range) {
                        tile.checkX = -range;
                        ++tile.checkZ;
                        if (tile.checkZ > range) {
                            tile.checkZ = -range;
                            --tile.checkY;
                        }
                    }
                }
            }
            if ((tile.oldEnergy != tile.storage.getEnergyStored() || tile.oldCheckX != tile.checkX || tile.oldCheckY != tile.checkY || tile.oldCheckZ != tile.checkZ) && tile.sendUpdateWithInterval()) {
                tile.oldEnergy = tile.storage.getEnergyStored();
                tile.oldCheckX = tile.checkX;
                tile.oldCheckY = tile.checkY;
                tile.oldCheckZ = tile.checkZ;
            }
        }
    }

    private boolean mine() {
        int actualUse = 650 * (this.onlyMineOres ? 3 : 1);
        if (this.storage.getEnergyStored() >= actualUse) {
            List drops;
            float chance;
            BlockPos pos = new BlockPos(this.worldPosition.getX() + this.checkX, this.checkY, this.worldPosition.getZ() + this.checkZ);
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            ItemStack stack = block.getCloneItemStack(state, (HitResult)new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, pos, false), (LevelReader)this.level, pos, (Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.level)));
            if (!state.isAir() && TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.NETHERITE, (BlockState)state) && state.getDestroySpeed((BlockGetter)this.level, pos) >= 0.0f && !(block instanceof IFluidBlock) && this.isMinable(state, stack) && (chance = WorldUtil.fireFakeHarvestEventsForDropChance(this, drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, (BlockEntity)this.level.getBlockEntity(pos)), this.level, pos)) > 0.0f && this.level.random.nextFloat() <= chance) {
                if (StackUtil.canAddAll(this.inv, drops, false)) {
                    this.level.levelEvent(2001, pos, Block.getId((BlockState)state));
                    this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    StackUtil.addAll(this.inv, drops, false);
                    this.setChanged();
                    this.storage.extractEnergyInternal(actualUse, false);
                    this.shootParticles(pos.getX(), pos.getY(), pos.getZ());
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isMinable(BlockState state, ItemStack stack) {
        Block block = state.getBlock();
        if (!state.isEmpty() && !this.isBlacklisted(block)) {
            if (!this.onlyMineOres) {
                return true;
            }
            if (!stack.isEmpty()) {
                if (stack.is(Tags.Items.ORES) || state.is(Tags.Blocks.ORES)) {
                    return true;
                }
                String reg = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
                if (!reg.isEmpty()) {
                    for (String string : (List)CommonConfig.Machines.MINER_EXTRA_WHITELIST.get()) {
                        if (!reg.equals(string)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void shootParticles(int endX, int endY, int endZ) {
        AssetUtil.spawnLaserWithTimeServer(this.level, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), endX, endY, endZ, 4363778, 10, 120.0, 0.1f, 0.8f);
    }

    private boolean isBlacklisted(Block block) {
        String reg = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        if (!reg.isEmpty()) {
            for (String string : (List)CommonConfig.Machines.MINER_BLACKLIST.get()) {
                if (!reg.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (stack, slot, automation) -> !automation;
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.onlyMineOres = !this.onlyMineOres;
            this.sendUpdate();
        } else if (buttonID == 1) {
            this.checkX = 0;
            this.checkY = -1;
            this.checkZ = 0;
        }
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.vertical_digger");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new ContainerMiner(windowId, playerInventory, this);
    }
}

