/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerXPSolidifier;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemSolidifiedExperience;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityXPSolidifier
extends TileEntityInventoryBase
implements IButtonReactor,
MenuProvider {
    private static final int[] XP_MAP = new int[256];
    private final int[] buttonAmounts = new int[]{1, 5, 10, 20, 30, 40, 50, 64, -999};
    public int amount;
    private int lastAmount;
    private int singlePointAmount;

    public TileEntityXPSolidifier(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.XP_SOLIDIFIER.getTileEntityType(), pos, state, 2);
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 0 && level < XP_MAP.length) {
            return XP_MAP[level];
        }
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        return TileEntityXPSolidifier.getExperienceForLevelImpl(level);
    }

    private static int getExperienceForLevelImpl(int level) {
        int res = 0;
        for (int i = 0; i < level; ++i) {
            if ((res += TileEntityXPSolidifier.getXpBarCapacity(i)) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return res;
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        int i;
        for (i = 0; i < XP_MAP.length; ++i) {
            if (XP_MAP[i] <= experience) continue;
            return i - 1;
        }
        i = XP_MAP.length;
        while (TileEntityXPSolidifier.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)TileEntityXPSolidifier.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.totalExperience = experience = Math.max(0, TileEntityXPSolidifier.getPlayerXP(player) + amount);
        player.experienceLevel = TileEntityXPSolidifier.getLevelForExperience(experience);
        int expForLevel = TileEntityXPSolidifier.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        compound.putInt("Amount", this.amount);
        compound.putInt("SinglePointAmount", this.singlePointAmount);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.amount = compound.getInt("Amount");
        this.singlePointAmount = compound.getInt("SinglePointAmount");
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityXPSolidifier) {
            TileEntityXPSolidifier tile = (TileEntityXPSolidifier)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityXPSolidifier) {
            ItemStack stack;
            TileEntityXPSolidifier tile = (TileEntityXPSolidifier)t;
            tile.serverTick();
            if (tile.amount > 0) {
                stack = tile.inv.getStackInSlot(0);
                if (stack.isEmpty()) {
                    int toSet = Math.min(tile.amount, 64);
                    tile.inv.setStackInSlot(0, new ItemStack((ItemLike)ActuallyItems.SOLIDIFIED_EXPERIENCE.get(), toSet));
                    tile.amount -= toSet;
                    tile.setChanged();
                } else if (stack.getCount() < 64) {
                    int needed = 64 - stack.getCount();
                    int toAdd = Math.min(needed, tile.amount);
                    stack.grow(toAdd);
                    tile.amount -= toAdd;
                    tile.setChanged();
                }
            }
            if (!tile.isRedstonePowered) {
                int range = 5;
                List orbs = level.getEntitiesOfClass(ExperienceOrb.class, new AABB((double)(pos.getX() - range), (double)(pos.getY() - range), (double)(pos.getZ() - range), (double)(pos.getX() + 1 + range), (double)(pos.getY() + 1 + range), (double)(pos.getZ() + 1 + range)));
                if (orbs != null && !orbs.isEmpty()) {
                    for (ExperienceOrb orb : orbs) {
                        if (orb == null || !orb.isAlive() || orb.getPersistentData().getBoolean("actuallyadditionsFromSolidified")) continue;
                        tile.singlePointAmount += orb.getValue();
                        orb.discard();
                        if (tile.singlePointAmount < 8) continue;
                        tile.amount += tile.singlePointAmount / 8;
                        tile.singlePointAmount = 0;
                        tile.setChanged();
                    }
                }
            }
            if (StackUtil.isValid(stack = tile.inv.getStackInSlot(1)) && stack.getItem() instanceof ItemSolidifiedExperience) {
                int remainingSpace = Mth.clamp((int)(Integer.MAX_VALUE - tile.amount), (int)0, (int)stack.getCount());
                if (stack.getCount() >= remainingSpace && remainingSpace != 0) {
                    tile.amount += remainingSpace;
                    stack.shrink(remainingSpace);
                    tile.setChanged();
                }
            }
            if (tile.lastAmount != tile.amount && tile.sendUpdateWithInterval()) {
                tile.lastAmount = tile.amount;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> slot == 1 && stack.getItem() == ActuallyItems.SOLIDIFIED_EXPERIENCE.get();
    }

    @Override
    public void setChanged() {
        if (this.amount < 0) {
            this.amount = Integer.MAX_VALUE;
        }
        super.setChanged();
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        int playerXP;
        if (buttonID < this.buttonAmounts.length && (playerXP = TileEntityXPSolidifier.getPlayerXP(player)) > 0) {
            int xp;
            int n = xp = this.buttonAmounts[buttonID] == -999 ? playerXP / 8 : this.buttonAmounts[buttonID];
            if (this.amount < Integer.MAX_VALUE - xp && playerXP >= 8 * xp) {
                TileEntityXPSolidifier.addPlayerXP(player, -(8 * xp));
                if (!this.level.isClientSide) {
                    this.amount += xp;
                }
            }
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.experienceSolidifier");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new ContainerXPSolidifier(windowId, playerInventory, this);
    }

    static {
        for (int i = 0; i < XP_MAP.length; ++i) {
            TileEntityXPSolidifier.XP_MAP[i] = TileEntityXPSolidifier.getExperienceForLevelImpl(i);
        }
    }
}

