/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderTypes;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.particle.ParticleBeam;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public final class AssetUtil {
    public static final int MAX_LIGHT_X = 0xF000F0;
    public static final int MAX_LIGHT_Y = 0xF000F0;
    public static final ResourceLocation GUI_INVENTORY_LOCATION = AssetUtil.getGuiLocation("gui_inventory");
    private static final ResourceLocation FORGE_WHITE = new ResourceLocation("forge", "white");

    public static ResourceLocation getGuiLocation(String file) {
        return new ResourceLocation("actuallyadditions", "textures/gui/" + file + ".png");
    }

    public static ResourceLocation getBookletGuiLocation(String file) {
        return AssetUtil.getGuiLocation("booklet/" + file);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayNameString(GuiGraphics guiGraphics, Font font, int xSize, int yPositionOfMachineText, String text) {
        guiGraphics.drawString(font, text, (float)xSize / 2.0f - (float)font.width(text) / 2.0f, (float)yPositionOfMachineText, 0xFFFFFF, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayNameString(GuiGraphics guiGraphics, Font font, int xSize, int yPositionOfMachineText, TileEntityBase tile) {
        AssetUtil.displayNameString(guiGraphics, font, xSize, yPositionOfMachineText, I18n.get((String)tile.getNameForTranslation(), (Object[])new Object[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemInWorld(ItemStack stack, int combinedLight, int combinedOverlay, PoseStack matrices, MultiBufferSource buffer) {
        if (!stack.isEmpty()) {
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrices, buffer, null, 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemWithoutScrewingWithColors(ItemStack stack, PoseStack matrices, int combinedOverlay, int combinedLight) {
        if (StackUtil.isValid(stack)) {
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer renderer = mc.getItemRenderer();
            TextureManager manager = mc.getTextureManager();
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            BakedModel model = renderer.getModel(stack, null, null, 0);
            manager.bindForSetup(TextureAtlas.LOCATION_BLOCKS);
            manager.getTexture(TextureAtlas.LOCATION_BLOCKS).setBlurMipmap(false, false);
            RenderSystem.enableBlend();
            matrices.pushPose();
            model = ClientHooks.handleCameraTransforms((PoseStack)matrices, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.FIXED, (boolean)false);
            renderer.render(stack, ItemDisplayContext.FIXED, false, matrices, (MultiBufferSource)bufferSource, combinedOverlay, combinedLight, model);
            matrices.popPose();
            RenderSystem.disableBlend();
            manager.bindForSetup(TextureAtlas.LOCATION_BLOCKS);
            manager.getTexture(TextureAtlas.LOCATION_BLOCKS).restoreLastBlurMipmap();
            bufferSource.endBatch();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStackToGui(ItemStack stack, int x, int y, float scale) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
    }

    public static void spawnLaserWithTimeServer(Level world, double startX, double startY, double startZ, double endX, double endY, double endZ, int color, int maxAge, double rotationTime, float size, float alpha) {
        if (!world.isClientSide) {
            CompoundTag data = new CompoundTag();
            data.putDouble("StartX", startX);
            data.putDouble("StartY", startY);
            data.putDouble("StartZ", startZ);
            data.putDouble("EndX", endX);
            data.putDouble("EndY", endY);
            data.putDouble("EndZ", endZ);
            data.putInt("Color", color);
            data.putDouble("RotationTime", rotationTime);
            data.putFloat("Size", size);
            data.putInt("MaxAge", maxAge);
            data.putFloat("Alpha", alpha);
            PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(startX, startY, startZ, 96.0, world.dimension())).send(new CustomPacketPayload[]{new PacketServerToClient(data, PacketHandler.LASER_HANDLER)});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnLaserWithTimeClient(double startX, double startY, double startZ, double endX, double endY, double endZ, int color, int maxAge, double rotationTime, float size, float alpha) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.distanceToSqr(startX, startY, startZ) <= 64.0 || mc.player.distanceToSqr(endX, endY, endZ) <= 64.0) {
            mc.level.addParticle(ParticleBeam.Factory.createData(endX, endY, endZ, color, alpha, maxAge, rotationTime, size), startX, startY, startZ, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLaser(PoseStack matrixStack, MultiBufferSource buffer, float offX, float offY, float offZ, float yaw, float pitch, float length, float rotationTime, int color, float alpha, float beamWidth) {
        ClientLevel world = Minecraft.getInstance().level;
        int r = (int)((float)(color >> 16 & 0xFF) * alpha);
        int g = (int)((float)(color >> 8 & 0xFF) * alpha);
        int b = (int)((float)(color & 0xFF) * alpha);
        int a = 255;
        int lightmap = LightTexture.pack((int)0xF000F0, (int)0xF000F0);
        float roll = rotationTime > 0.0f ? 360.0f * ((float)world.getGameTime() % rotationTime / rotationTime) : 0.0f;
        VertexConsumer builder = buffer.getBuffer(RenderTypes.LASER);
        matrixStack.pushPose();
        matrixStack.translate(0.5f, 0.5f, 0.5f);
        matrixStack.translate(offX, offY, offZ);
        matrixStack.mulPose(Axis.YP.rotationDegrees(yaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(pitch));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(roll));
        Matrix4f matrix = matrixStack.last().pose();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(FORGE_WHITE);
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        for (int i = 1; i < 4; ++i) {
            float width = beamWidth * ((float)i / 4.0f);
            builder.vertex(matrix, -width, width, 0.0f).color(r, g, b, a).uv(minU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, -length).color(r, g, b, a).uv(maxU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, 0.0f).color(r, g, b, a).uv(minU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, -length).color(r, g, b, a).uv(maxU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
        }
        matrixStack.popPose();
    }

    public static void renderLaser(PoseStack matrixStack, MultiBufferSource buffer, Vec3 startOffset, Vec3 endOffset, float rotationTime, int color, float alpha, float beamWidth) {
        Vec3 combined = endOffset.subtract(startOffset);
        double pitch = Math.toDegrees(Math.atan2(combined.y, Math.sqrt(combined.x * combined.x + combined.z * combined.z)));
        double yaw = Math.toDegrees(Math.atan2(-combined.z, combined.x));
        double length = combined.length();
        AssetUtil.renderLaser(matrixStack, buffer, (float)startOffset.x, (float)startOffset.y, (float)startOffset.z, (float)yaw, (float)pitch, (float)length, rotationTime, color, alpha, beamWidth);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLaserParticle(VertexConsumer builder, Camera camera, double firstX, double firstY, double firstZ, double secondX, double secondY, double secondZ, float rotationTime, float a, float beamWidth, float[] color) {
        ClientLevel world = Minecraft.getInstance().level;
        Vec3 cam = camera.getPosition();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Vec3 vec1 = new Vec3(firstX, firstY, firstZ);
        Vec3 vec2 = new Vec3(secondX, secondY, secondZ);
        Vec3 combinedVec = vec2.subtract(vec1);
        int lightmap = LightTexture.pack((int)0xF000F0, (int)0xF000F0);
        double roll = rotationTime > 0.0f ? 360.0 * (double)((float)world.getGameTime() % rotationTime / rotationTime) : 0.0;
        double pitch = Math.toDegrees(Math.atan2(combinedVec.y, Math.sqrt(combinedVec.x * combinedVec.x + combinedVec.z * combinedVec.z)));
        double yaw = Math.toDegrees(Math.atan2(-combinedVec.z, combinedVec.x)) - 90.0;
        float length = (float)combinedVec.length();
        PoseStack matrixStack = new PoseStack();
        matrixStack.pushPose();
        matrixStack.translate(firstX - cam.x, firstY - cam.y, firstZ - cam.z);
        matrixStack.mulPose(Axis.YP.rotationDegrees((float)yaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees((float)pitch));
        matrixStack.mulPose(Axis.ZP.rotationDegrees((float)roll));
        Matrix4f matrix = matrixStack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorLightmapShader);
        Tesselator.getInstance().getBuilder().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_LIGHTMAP);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(FORGE_WHITE);
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        for (int i = 1; i < 4; ++i) {
            float width = beamWidth * ((float)i / 4.0f);
            builder.vertex(matrix, -width, width, 0.0f).color(r, g, b, a).uv(minU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, -length).color(r, g, b, a).uv(maxU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, 0.0f).color(r, g, b, a).uv(minU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, -length).color(r, g, b, a).uv(maxU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, -width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, -width, width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, 0.0f).color(r, g, b, a).uv(maxU, maxV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, -width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
            builder.vertex(matrix, width, width, -length).color(r, g, b, a).uv(minU, minV).uv2(lightmap).endVertex();
        }
        matrixStack.popPose();
        Tesselator.getInstance().end();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTextInWorld(GuiGraphics guiGraphics, double offsetX, double offsetY, double offsetZ, NonNullList<String> text, int color) {
        PoseStack matrices = guiGraphics.pose();
        matrices.pushPose();
        matrices.translate(offsetX, offsetY, offsetZ);
        matrices.scale(-1.0f, -1.0f, 1.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(Minecraft.getInstance().cameraEntity.getYRot()));
        matrices.scale(0.01f, 0.01f, 0.01f);
        Font font = Minecraft.getInstance().font;
        int y = 0;
        for (String s : text) {
            guiGraphics.drawString(font, s, 0, y, color);
            y += 10;
        }
        matrices.popPose();
    }

    public static float[] getWheelColor(float pos) {
        if (pos < 85.0f) {
            return new float[]{pos * 3.0f, 255.0f - pos * 3.0f, 0.0f};
        }
        if (pos < 170.0f) {
            return new float[]{255.0f - (pos -= 85.0f) * 3.0f, 0.0f, pos * 3.0f};
        }
        return new float[]{0.0f, (pos -= 170.0f) * 3.0f, 255.0f - pos * 3.0f};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHitOutline(PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, Level level, BlockPos pos, BlockState state) {
        AssetUtil.renderShape(poseStack, consumer, state.getShape((BlockGetter)level, pos, CollisionContext.of((Entity)entity)), (double)pos.getX() - camX, (double)pos.getY() - camY, (double)pos.getZ() - camZ, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose posestack$pose = poseStack.last();
        shape.forAllEdges((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float f = (float)(maxX - minX);
            float f1 = (float)(maxY - minY);
            float f2 = (float)(maxZ - minZ);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            consumer.vertex(posestack$pose.pose(), (float)(minX + x), (float)(minY + y), (float)(minZ + z)).color(red, green, blue, alpha).normal(posestack$pose.normal(), f /= f3, f1 /= f3, f2 /= f3).endVertex();
            consumer.vertex(posestack$pose.pose(), (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).color(red, green, blue, alpha).normal(posestack$pose.normal(), f, f1, f2).endVertex();
        });
    }
}

