/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Arrays;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class CoordsModule
extends BaseModule {
    public TextColor colorX;
    public TextColor colorY;
    public TextColor colorZ;
    public final TextColor defaultColorX = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED);
    public final TextColor defaultColorY = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN);
    public final TextColor defaultColorZ = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA);

    public CoordsModule() {
        this.nameColor = this.defaultNameColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED);
        this.colorX = this.defaultColorX;
        this.colorY = this.defaultColorY;
        this.colorZ = this.defaultColorZ;
        this.lines.add(new DebugLine("player_coords", "format.betterf3.coords", true));
        this.lines.add(new DebugLine("block_coords", "format.betterf3.coords", true));
        this.lines.add(new DebugLine("chunk_relative_coords", "format.betterf3.coords", true));
        this.lines.add(new DebugLine("chunk_coords", "format.betterf3.coords", true));
        this.lines.add(new DebugLine("velocity", "format.betterf3.coords", true));
        this.lines.add(new DebugLine("abs_velocity"));
        ((DebugLine)this.lines.get((int)2)).inReducedDebug = true;
    }

    @Override
    public void update(Minecraft client) {
        Entity cameraEntity = client.getCameraEntity();
        MutableComponent xyz = Utils.styledText("X", this.colorX).append((Component)Utils.styledText("Y", this.colorY)).append((Component)Utils.styledText("Z", this.colorZ));
        if (cameraEntity != null) {
            String cameraX = String.format("%.3f", cameraEntity.getX());
            String cameraY = String.format("%.5f", cameraEntity.getY());
            String cameraZ = String.format("%.3f", cameraEntity.getZ());
            ((DebugLine)this.lines.get(0)).value(Arrays.asList(xyz, Utils.styledText(cameraX, this.colorX), Utils.styledText(cameraY, this.colorY), Utils.styledText(cameraZ, this.colorZ)));
            BlockPos blockPos = cameraEntity.blockPosition();
            ((DebugLine)this.lines.get(1)).value(Arrays.asList(Utils.styledText(blockPos.getX(), this.colorX), Utils.styledText(blockPos.getY(), this.colorY), Utils.styledText(blockPos.getZ(), this.colorZ)));
            ((DebugLine)this.lines.get(2)).value(Arrays.asList(Utils.styledText(blockPos.getX() & 0xF, this.colorX), Utils.styledText(blockPos.getY() & 0xF, this.colorY), Utils.styledText(blockPos.getZ() & 0xF, this.colorZ)));
            ((DebugLine)this.lines.get(3)).value(Arrays.asList(Utils.styledText(blockPos.getX() >> 4, this.colorX), Utils.styledText(blockPos.getY() >> 4, this.colorY), Utils.styledText(blockPos.getZ() >> 4, this.colorZ)));
            Entity vehicle = cameraEntity.getRootVehicle();
            int ticksPerSecond = 20;
            Vec3 velocity = vehicle != null ? vehicle.getDeltaMovement() : cameraEntity.getDeltaMovement();
            String vX = String.format("%.3f", velocity.x() * 20.0);
            String vY = String.format("%.3f", velocity.y() * 20.0);
            String vZ = String.format("%.3f", velocity.z() * 20.0);
            ((DebugLine)this.lines.get(4)).value(Arrays.asList(Utils.styledText(vX, this.colorX), Utils.styledText(vY, this.colorY), Utils.styledText(vZ, this.colorZ)));
            ((DebugLine)this.lines.get(5)).value(Utils.styledText(String.format("%.3f", velocity.length() * 20.0), this.defaultNameColor));
        }
    }
}

