/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;

public class LocationModule
extends BaseModule {
    @Nullable
    private CompletableFuture<LevelChunk> chunkFuture;

    public LocationModule() {
        this.defaultNameColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_GREEN);
        this.defaultValueColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.AQUA);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("dimension"));
        this.lines.add(new DebugLine("facing"));
        this.lines.add(new DebugLine("rotation"));
        this.lines.add(new DebugLine("light"));
        this.lines.add(new DebugLine("light_server"));
        this.lines.add(new DebugLine("highest_block"));
        this.lines.add(new DebugLine("highest_block_server"));
        this.lines.add(new DebugLine("biome"));
        this.lines.add(new DebugLine("local_difficulty"));
        this.lines.add(new DebugLine("day_ticks"));
        this.lines.add(new DebugLine("days_played"));
        this.lines.add(new DebugLine("slime_chunk"));
    }

    @Override
    public void update(Minecraft client) {
        Entity cameraEntity = client.getCameraEntity();
        IntegratedServer integratedServer = client.getSingleplayerServer();
        String chunkLightString = "";
        String chunkLightServerString = "";
        String localDifficultyString = "";
        String slimeChunkString = "";
        StringBuilder highestBlock = new StringBuilder();
        StringBuilder highestBlockServer = new StringBuilder();
        if (client.level != null) {
            assert (cameraEntity != null);
            BlockPos blockPos = cameraEntity.blockPosition();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            ((DebugLine)this.lines.get(7)).value(client.level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)client.level.getBiome(blockPos).value())));
            ClientLevel serverWorld = integratedServer != null ? integratedServer.getLevel(client.level.dimension()) : client.level;
            LevelChunk clientChunk = client.level.getChunk(chunkPos.x, chunkPos.z);
            if (clientChunk.isEmpty()) {
                chunkLightString = I18n.get((String)"text.betterf3.line.waiting_chunk", (Object[])new Object[0]);
            } else if (serverWorld != null) {
                LevelChunk serverChunk;
                int totalLight = client.level.getChunkSource().getLightEngine().getRawBrightness(blockPos, 0);
                int skyLight = client.level.getBrightness(LightLayer.SKY, blockPos);
                int blockLight = client.level.getBrightness(LightLayer.BLOCK, blockPos);
                chunkLightString = I18n.get((String)"format.betterf3.chunklight", (Object[])new Object[]{totalLight, skyLight, blockLight});
                LevelLightEngine lightingProvider = serverWorld.getChunkSource().getLightEngine();
                int skyLightServer = lightingProvider.getLayerListener(LightLayer.SKY).getLightValue(blockPos);
                int blockLightServer = lightingProvider.getLayerListener(LightLayer.BLOCK).getLightValue(blockPos);
                chunkLightServerString = I18n.get((String)"format.betterf3.chunklight_server", (Object[])new Object[]{skyLightServer, blockLightServer});
                Heightmap.Types[] heightmapTypes = Heightmap.Types.values();
                if (serverWorld instanceof ServerLevel) {
                    if (this.chunkFuture == null) {
                        this.chunkFuture = ((ServerLevel)serverWorld).getChunkSource().getChunkFuture(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false).thenApply(either -> (LevelChunk)either.map(chunk -> (LevelChunk)chunk, chunk -> null));
                    }
                    if (this.chunkFuture == null) {
                        this.chunkFuture = CompletableFuture.completedFuture(clientChunk);
                    }
                    serverChunk = this.chunkFuture.getNow(null);
                } else {
                    serverChunk = clientChunk;
                }
                for (Heightmap.Types type : heightmapTypes) {
                    int blockY;
                    String typeString;
                    if (type.sendToClient()) {
                        typeString = (String)DebugScreenOverlay.HEIGHTMAP_NAMES.get(type);
                        blockY = clientChunk.getHeight(type, blockPos.getX(), blockPos.getZ());
                        if (blockY > -1) {
                            highestBlock.append("  ").append(typeString).append(": ").append(blockY);
                        }
                    }
                    if (!type.keepAfterWorldgen() || !(serverWorld instanceof ServerLevel)) continue;
                    if (serverChunk == null) {
                        serverChunk = clientChunk;
                    }
                    typeString = (String)DebugScreenOverlay.HEIGHTMAP_NAMES.get(type);
                    blockY = serverChunk.getHeight(type, blockPos.getX(), blockPos.getZ());
                    if (blockY <= -1) continue;
                    highestBlockServer.append("  ").append(typeString).append(": ").append(blockY);
                }
                if (blockPos.getY() >= 0 && blockPos.getY() < 256) {
                    float moonSize = serverWorld.getMoonBrightness();
                    long inhabitedTime = Objects.requireNonNullElse(serverChunk, clientChunk).getInhabitedTime();
                    DifficultyInstance localDifficulty = new DifficultyInstance(serverWorld.getDifficulty(), serverWorld.getDayTime(), inhabitedTime, moonSize);
                    localDifficultyString = String.format("%.2f  " + I18n.get((String)"text.betterf3.line.clamped", (Object[])new Object[0]) + ": %.2f", Float.valueOf(localDifficulty.getEffectiveDifficulty()), Float.valueOf(localDifficulty.getSpecialMultiplier()));
                }
                if (integratedServer != null) {
                    RandomSource slimeChunk = WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)((WorldGenLevel)serverWorld).getSeed(), (long)987234911L);
                    slimeChunkString = String.format("%s", I18n.get((String)(slimeChunk.nextInt(10) == 0 ? "text.betterf3.line.slime_chunk.true" : "text.betterf3.line.slime_chunk.false"), (Object[])new Object[0]));
                } else {
                    slimeChunkString = String.format("%s", I18n.get((String)"text.betterf3.line.slime_chunk.unknown", (Object[])new Object[0]));
                }
            }
        }
        if (client.level != null) {
            ((DebugLine)this.lines.get(0)).value(client.level.dimension().location());
        }
        if (cameraEntity != null) {
            Direction facing = cameraEntity.getDirection();
            String facingString = Utils.facingString(facing);
            ((DebugLine)this.lines.get(1)).value(String.format("%s (%s)", I18n.get((String)("text.betterf3.line." + facing.toString().toLowerCase()), (Object[])new Object[0]), facingString));
            String yaw = String.format("%.1f", Float.valueOf(Mth.wrapDegrees((float)cameraEntity.getYRot())));
            String pitch = String.format("%.1f", Float.valueOf(Mth.wrapDegrees((float)cameraEntity.getXRot())));
            ((DebugLine)this.lines.get(2)).value(I18n.get((String)"format.betterf3.rotation", (Object[])new Object[]{yaw, pitch}));
        }
        ((DebugLine)this.lines.get(3)).value(chunkLightString);
        ((DebugLine)this.lines.get(4)).value(chunkLightServerString);
        ((DebugLine)this.lines.get(5)).value(highestBlock.toString().trim());
        ((DebugLine)this.lines.get(6)).value(highestBlockServer.toString().trim());
        ((DebugLine)this.lines.get(8)).value(localDifficultyString);
        ((DebugLine)this.lines.get(9)).value(Long.valueOf(client.level.getDayTime() % 24000L).intValue());
        ((DebugLine)this.lines.get(10)).value(client.level.getDayTime() / 24000L);
        ((DebugLine)this.lines.get(11)).value(slimeChunkString.trim());
    }
}

