/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.MiscLeftModule;
import me.cominixo.betterf3.modules.MiscRightModule;
import me.cominixo.betterf3.utils.PositionEnum;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class DebugRenderer {
    private DebugRenderer() {
    }

    public static MultiBufferSource.BufferSource immediate(Minecraft minecraft, Font font, PositionEnum pos, List<Component> list, PoseStack matrixStack) {
        float f = (float)(GeneralOptions.backgroundColor >> 24 & 0xFF) / 255.0f;
        float g = (float)(GeneralOptions.backgroundColor >> 16 & 0xFF) / 255.0f;
        float h = (float)(GeneralOptions.backgroundColor >> 8 & 0xFF) / 255.0f;
        float k = (float)(GeneralOptions.backgroundColor & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i < list.size(); ++i) {
            int j;
            int x2;
            int x1;
            int height = 9;
            int width = font.width(list.get(i).getString());
            if (width == 0) continue;
            int y = 2 + 9 * i;
            if (pos == PositionEnum.RIGHT) {
                windowWidth = (int)((double)minecraft.getWindow().getGuiScaledWidth() / GeneralOptions.fontScale) - 2 - width;
                if (GeneralOptions.enableAnimations) {
                    windowWidth += Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = windowWidth + width + 1;
            } else {
                windowWidth = 2;
                if (GeneralOptions.enableAnimations) {
                    windowWidth -= Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = width + 1 + windowWidth;
            }
            int y1 = y - 1;
            int y2 = y + 9 - 1;
            Matrix4f matrix = matrixStack.last().pose();
            if (x1 < x2) {
                j = x1;
                x1 = x2;
                x2 = j;
            }
            if (y1 < y2) {
                j = y1;
                y1 = y2;
                y2 = j;
            }
            bufferBuilder.vertex(matrix, (float)x1, (float)y2, 0.0f).color(g, h, k, f).endVertex();
            bufferBuilder.vertex(matrix, (float)x2, (float)y2, 0.0f).color(g, h, k, f).endVertex();
            bufferBuilder.vertex(matrix, (float)x2, (float)y1, 0.0f).color(g, h, k, f).endVertex();
            bufferBuilder.vertex(matrix, (float)x1, (float)y1, 0.0f).color(g, h, k, f).endVertex();
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.disableBlend();
        return MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
    }

    public static void drawRightText(List<Component> list, GuiGraphics context, Minecraft minecraft, Font font, @Nullable List<String> additional) {
        if (additional != null) {
            additional.forEach(text -> list.add(Component.nullToEmpty((String)text)));
        }
        MultiBufferSource.BufferSource immediate = DebugRenderer.immediate(minecraft, font, PositionEnum.RIGHT, list, context.pose());
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int width = font.width(list.get(i).getString());
            int windowWidth = (int)((double)minecraft.getWindow().getGuiScaledWidth() / GeneralOptions.fontScale) - 2 - width;
            if (GeneralOptions.enableAnimations) {
                windowWidth += Utils.xPos;
            }
            int y = 2 + 9 * i;
            font.drawInBatch(list.get(i), (float)windowWidth, (float)y, 0xE0E0E0, GeneralOptions.shadowText, context.pose().last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        immediate.endBatch();
        context.pose().popPose();
    }

    public static void drawLeftText(List<Component> list, GuiGraphics context, Minecraft minecraft, Font font, @Nullable List<String> additional) {
        if (additional != null) {
            additional.forEach(text -> list.add(Component.nullToEmpty((String)text)));
        }
        MultiBufferSource.BufferSource immediate = DebugRenderer.immediate(minecraft, font, PositionEnum.LEFT, list, context.pose());
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int y = 2 + 9 * i;
            int xPosLeft = 2;
            if (GeneralOptions.enableAnimations) {
                xPosLeft -= Utils.xPos;
            }
            font.drawInBatch(list.get(i), (float)xPosLeft, (float)y, 0xE0E0E0, GeneralOptions.shadowText, context.pose().last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        immediate.endBatch();
    }

    public static List<Component> newText(Minecraft minecraft, boolean left, List<String> gameInformation, List<String> systemInformation) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (BaseModule module : left ? BaseModule.modules : BaseModule.modulesRight) {
            if (!module.enabled) continue;
            if (module instanceof MiscRightModule) {
                ((MiscRightModule)module).update(systemInformation);
            } else if (module instanceof MiscLeftModule) {
                ((MiscLeftModule)module).update(gameInformation);
            } else {
                module.update(minecraft);
            }
            list.addAll(module.linesFormatted(minecraft.showOnlyReducedInfo()));
            if (!GeneralOptions.spaceEveryModule) continue;
            list.add(Component.nullToEmpty((String)""));
        }
        return list;
    }
}

