/*
 * Decompiled with CFR 0.152.
 */
package me.treyruffy.betterf3.mixin;

import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.utils.DebugRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class NeoForgeDebugMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private Font font;

    @Shadow
    protected abstract List<String> getGameInformation();

    @Shadow
    protected abstract List<String> getSystemInformation();

    @Inject(method={"drawGameInformation(Lnet/minecraft/client/gui/GuiGraphics;Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawLeftText(GuiGraphics context, List<String> additional, CallbackInfo ci) {
        if (GeneralOptions.disableMod) {
            return;
        }
        List<Component> list = DebugRenderer.newText(this.minecraft, true, this.getGameInformation(), this.getSystemInformation());
        DebugRenderer.drawLeftText(list, context, this.minecraft, this.font, additional);
        ci.cancel();
    }

    @Inject(method={"drawSystemInformation(Lnet/minecraft/client/gui/GuiGraphics;Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawRightText(GuiGraphics context, List<String> additional, CallbackInfo ci) {
        if (GeneralOptions.disableMod) {
            return;
        }
        List<Component> list = DebugRenderer.newText(this.minecraft, false, this.getGameInformation(), this.getSystemInformation());
        DebugRenderer.drawRightText(list, context, this.minecraft, this.font, additional);
        ci.cancel();
    }
}

