/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.impl;

import com.mojang.datafixers.util.Either;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface RegistrySupplierImpl<T>
extends RegistrySupplier<T> {
    @Nullable
    public Holder<T> getHolder();

    default public T value() {
        return this.get();
    }

    default public boolean isBound() {
        return this.isPresent();
    }

    default public boolean is(ResourceLocation resourceLocation) {
        return this.getId().equals((Object)resourceLocation);
    }

    default public boolean is(ResourceKey<T> resourceKey) {
        return this.getKey().equals(resourceKey);
    }

    default public boolean is(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.getKey());
    }

    default public boolean is(TagKey<T> tagKey) {
        Holder<T> holder = this.getHolder();
        return holder != null && holder.is(tagKey);
    }

    default public Stream<TagKey<T>> tags() {
        Holder<T> holder = this.getHolder();
        return holder != null ? holder.tags() : Stream.empty();
    }

    default public Either<ResourceKey<T>, T> unwrap() {
        return Either.left(this.getKey());
    }

    default public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.of(this.getKey());
    }

    default public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    default public boolean canSerializeIn(HolderOwner<T> holderOwner) {
        Holder<T> holder = this.getHolder();
        return holder != null && holder.canSerializeIn(holderOwner);
    }
}

