/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.forge.NetworkManagerImpl;
import dev.architectury.networking.transformers.PacketCollector;
import dev.architectury.networking.transformers.PacketSink;
import dev.architectury.networking.transformers.PacketTransformer;
import dev.architectury.networking.transformers.SinglePacketCollector;
import dev.architectury.utils.Env;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkManager {
    public static void registerReceiver(Side side, ResourceLocation id, NetworkReceiver receiver) {
        NetworkManager.registerReceiver(side, id, Collections.emptyList(), receiver);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkReceiver receiver) {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManagerImpl.registerReceiver(side, (ResourceLocation)var1_1, (List<PacketTransformer>)var2_2, (NetworkReceiver)var3_3);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Packet<?> toPacket(Side side, ResourceLocation id, FriendlyByteBuf buf) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets(sink, side, id, buf);
        return sink.getPacket();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static List<Packet<?>> toPackets(Side side, ResourceLocation id, FriendlyByteBuf buf) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets(sink, side, id, buf);
        return sink.collect();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void collectPackets(PacketSink sink, Side side, ResourceLocation id, FriendlyByteBuf buf) {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManagerImpl.collectPackets(sink, (Side)var1_1, (ResourceLocation)var2_2, (FriendlyByteBuf)var3_3);
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation id, FriendlyByteBuf buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), id, buf);
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation id, FriendlyByteBuf buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), id, buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation id, FriendlyByteBuf buf) {
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), id, buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(ResourceLocation id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (ResourceLocation)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<ClientGamePacketListener> createAddEntityPacket(Entity entity) {
        return NetworkManagerImpl.createAddEntityPacket(entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(FriendlyByteBuf var1, PacketContext var2);
    }

    public static interface PacketContext {
        public Player getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public Dist getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }
}

