/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SpawnEntityPacket {
    private static final ResourceLocation PACKET_ID = new ResourceLocation("architectury", "spawn_entity_packet");

    public static Packet<ClientGamePacketListener> create(Entity entity) {
        if (entity.level().isClientSide()) {
            throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeVarInt(BuiltInRegistries.ENTITY_TYPE.getId((Object)entity.getType()));
        buffer.writeUUID(entity.getUUID());
        buffer.writeVarInt(entity.getId());
        Vec3 position = entity.position();
        buffer.writeDouble(position.x);
        buffer.writeDouble(position.y);
        buffer.writeDouble(position.z);
        buffer.writeFloat(entity.getXRot());
        buffer.writeFloat(entity.getYRot());
        buffer.writeFloat(entity.getYHeadRot());
        Vec3 deltaMovement = entity.getDeltaMovement();
        buffer.writeDouble(deltaMovement.x);
        buffer.writeDouble(deltaMovement.y);
        buffer.writeDouble(deltaMovement.z);
        if (entity instanceof EntitySpawnExtension) {
            EntitySpawnExtension ext = (EntitySpawnExtension)entity;
            ext.saveAdditionalSpawnData(buffer);
        }
        return NetworkManager.toPacket(NetworkManager.s2c(), PACKET_ID, buffer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        @OnlyIn(value=Dist.CLIENT)
        public static void register() {
            NetworkManager.registerReceiver(NetworkManager.s2c(), PACKET_ID, Client::receive);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void receive(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
            int entityTypeId = buf.readVarInt();
            UUID uuid = buf.readUUID();
            int id = buf.readVarInt();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xRot = buf.readFloat();
            float yRot = buf.readFloat();
            float yHeadRot = buf.readFloat();
            double deltaX = buf.readDouble();
            double deltaY = buf.readDouble();
            double deltaZ = buf.readDouble();
            buf.retain();
            context.queue(() -> {
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.byId(entityTypeId);
                if (entityType == null) {
                    throw new IllegalStateException("Entity type (" + entityTypeId + ") is unknown, spawning at (" + x + ", " + y + ", " + z + ")");
                }
                if (Minecraft.getInstance().level == null) {
                    throw new IllegalStateException("Client world is null!");
                }
                Entity entity = entityType.create((Level)Minecraft.getInstance().level);
                if (entity == null) {
                    throw new IllegalStateException("Created entity is null!");
                }
                entity.setUUID(uuid);
                entity.setId(id);
                entity.syncPacketPositionCodec(x, y, z);
                entity.moveTo(x, y, z);
                entity.setXRot(xRot);
                entity.setYRot(yRot);
                entity.setYHeadRot(yHeadRot);
                entity.setYBodyRot(yHeadRot);
                if (entity instanceof EntitySpawnExtension) {
                    EntitySpawnExtension ext = (EntitySpawnExtension)entity;
                    ext.loadAdditionalSpawnData(buf);
                }
                buf.release();
                Minecraft.getInstance().level.addEntity(entity);
                entity.lerpMotion(deltaX, deltaY, deltaZ);
            });
        }
    }
}

