/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.forge;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.forge.BufCustomPacketPayload;
import dev.architectury.networking.forge.NetworkManagerImpl;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworkingManager {
    public static IPlayPayloadHandler<BufCustomPacketPayload> initClient() {
        IPlayPayloadHandler<BufCustomPacketPayload> handler = NetworkManagerImpl.createPacketHandler(NetworkManager.Side.S2C, NetworkManagerImpl.S2C_TRANSFORMERS);
        NeoForge.EVENT_BUS.register(ClientNetworkingManager.class);
        NetworkManagerImpl.registerS2CReceiver(NetworkManagerImpl.SYNC_IDS, Collections.emptyList(), (buffer, context) -> {
            Set<ResourceLocation> receivables = NetworkManagerImpl.serverReceivables;
            int size = buffer.readInt();
            receivables.clear();
            for (int i = 0; i < size; ++i) {
                receivables.add(buffer.readResourceLocation());
            }
            context.queue(() -> NetworkManager.sendToServer(NetworkManagerImpl.SYNC_IDS, NetworkManagerImpl.sendSyncPacket(NetworkManagerImpl.C2S)));
        });
        return handler;
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @SubscribeEvent
    public static void loggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        NetworkManagerImpl.serverReceivables.clear();
    }
}

