/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.forge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.SpawnEntityPacket;
import dev.architectury.networking.forge.BufCustomPacketPayload;
import dev.architectury.networking.forge.ClientNetworkingManager;
import dev.architectury.networking.transformers.PacketSink;
import dev.architectury.networking.transformers.PacketTransformer;
import dev.architectury.platform.hooks.forge.EventBusesHooksImpl;
import dev.architectury.utils.Env;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.DistExecutor;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="architectury")
public class NetworkManagerImpl {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final ResourceLocation CHANNEL_ID = new ResourceLocation("architectury:network");
    static final ResourceLocation SYNC_IDS = new ResourceLocation("architectury:sync_ids");
    static final Map<ResourceLocation, NetworkManager.NetworkReceiver> S2C = Maps.newHashMap();
    static final Map<ResourceLocation, NetworkManager.NetworkReceiver> C2S = Maps.newHashMap();
    static final Map<ResourceLocation, PacketTransformer> S2C_TRANSFORMERS = Maps.newHashMap();
    static final Map<ResourceLocation, PacketTransformer> C2S_TRANSFORMERS = Maps.newHashMap();
    static final Set<ResourceLocation> serverReceivables = Sets.newHashSet();
    private static final Multimap<Player, ResourceLocation> clientReceivables = Multimaps.newMultimap((Map)Maps.newHashMap(), Sets::newHashSet);

    public static void registerReceiver(NetworkManager.Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        Objects.requireNonNull(id, "Cannot register receiver with a null ID!");
        packetTransformers = Objects.requireNonNullElse(packetTransformers, List.of());
        Objects.requireNonNull(receiver, "Cannot register a null receiver!");
        if (side == NetworkManager.Side.C2S) {
            NetworkManagerImpl.registerC2SReceiver(id, packetTransformers, receiver);
        } else if (side == NetworkManager.Side.S2C) {
            NetworkManagerImpl.registerS2CReceiver(id, packetTransformers, receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Packet<?> toPacket(NetworkManager.Side side, ResourceLocation id, FriendlyByteBuf buffer) {
        try {
            ServerboundCustomPayloadPacket serverboundCustomPayloadPacket = side == NetworkManager.Side.C2S ? new ServerboundCustomPayloadPacket((CustomPacketPayload)new BufCustomPacketPayload(id, ByteBufUtil.getBytes((ByteBuf)buffer))) : new ClientboundCustomPayloadPacket((CustomPacketPayload)new BufCustomPacketPayload(id, ByteBufUtil.getBytes((ByteBuf)buffer)));
            return serverboundCustomPayloadPacket;
        }
        finally {
            buffer.release();
        }
    }

    public static void collectPackets(PacketSink sink, NetworkManager.Side side, ResourceLocation id, FriendlyByteBuf buf) {
        PacketTransformer transformer;
        PacketTransformer packetTransformer = transformer = side == NetworkManager.Side.C2S ? C2S_TRANSFORMERS.get(id) : S2C_TRANSFORMERS.get(id);
        if (transformer != null) {
            transformer.outbound(side, id, buf, (side1, id1, buf1) -> sink.accept(NetworkManagerImpl.toPacket(side1, id1, buf1)));
        } else {
            sink.accept(NetworkManagerImpl.toPacket(side, id, buf));
        }
    }

    static IPlayPayloadHandler<BufCustomPacketPayload> createPacketHandler(NetworkManager.Side direction, Map<ResourceLocation, PacketTransformer> map) {
        return (arg, context) -> {
            NetworkManager.Side side = NetworkManagerImpl.side(context.flow());
            if (side != direction) {
                return;
            }
            ResourceLocation type = arg.type();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])arg.payload()));
            PacketTransformer transformer = (PacketTransformer)map.get(type);
            try {
                if (transformer != null) {
                    NetworkManager.PacketContext packetContext = new NetworkManager.PacketContext(){

                        @Override
                        public Player getPlayer() {
                            return this.getEnvironment() == Env.CLIENT ? this.getClientPlayer() : (Player)context.player().orElse(null);
                        }

                        @Override
                        public void queue(Runnable runnable) {
                            context.workHandler().submitAsync(runnable);
                        }

                        @Override
                        public Env getEnvironment() {
                            return context.flow().getReceptionSide() == LogicalSide.CLIENT ? Env.CLIENT : Env.SERVER;
                        }

                        private Player getClientPlayer() {
                            return (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::getClientPlayer);
                        }
                    };
                    transformer.inbound(side, type, buf, packetContext, (side1, id1, buf1) -> {
                        NetworkManager.NetworkReceiver networkReceiver;
                        NetworkManager.NetworkReceiver networkReceiver2 = networkReceiver = side == NetworkManager.Side.C2S ? C2S.get(id1) : S2C.get(id1);
                        if (networkReceiver == null) {
                            throw new IllegalArgumentException("Network Receiver not found! " + id1);
                        }
                        networkReceiver.receive(buf1, packetContext);
                    });
                } else {
                    LOGGER.error("Unknown message ID: " + type);
                }
            }
            finally {
                buf.release();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerS2CReceiver(ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        LOGGER.info("Registering S2C receiver with id {}", (Object)id);
        S2C.put(id, receiver);
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        S2C_TRANSFORMERS.put(id, transformer);
    }

    public static void registerC2SReceiver(ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        LOGGER.info("Registering C2S receiver with id {}", (Object)id);
        C2S.put(id, receiver);
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        C2S_TRANSFORMERS.put(id, transformer);
    }

    public static boolean canServerReceive(ResourceLocation id) {
        return serverReceivables.contains(id);
    }

    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        return clientReceivables.get((Object)player).contains(id);
    }

    public static Packet<ClientGamePacketListener> createAddEntityPacket(Entity entity) {
        return SpawnEntityPacket.create(entity);
    }

    static FriendlyByteBuf sendSyncPacket(Map<ResourceLocation, NetworkManager.NetworkReceiver> map) {
        ArrayList availableIds = Lists.newArrayList(map.keySet());
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.writeInt(availableIds.size());
        for (ResourceLocation availableId : availableIds) {
            packetBuffer.writeResourceLocation(availableId);
        }
        return packetBuffer;
    }

    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkManager.sendToPlayer((ServerPlayer)event.getEntity(), SYNC_IDS, NetworkManagerImpl.sendSyncPacket(C2S));
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        clientReceivables.removeAll((Object)event.getEntity());
    }

    public static void registerPackets(RegisterPayloadHandlerEvent event) {
        @Nullable IPlayPayloadHandler s2c = (IPlayPayloadHandler)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::initClient);
        IPayloadRegistrar registrar = event.registrar("architectury").optional();
        registrar.play(CHANNEL_ID, BufCustomPacketPayload::new, builder -> builder.server(NetworkManagerImpl.createPacketHandler(NetworkManager.Side.C2S, C2S_TRANSFORMERS)).client((Object)Objects.requireNonNullElseGet(s2c, IPlayPayloadHandler::noop)));
        NetworkManagerImpl.registerC2SReceiver(SYNC_IDS, Collections.emptyList(), (buffer, context) -> {
            Set receivables = (Set)clientReceivables.get((Object)context.getPlayer());
            int size = buffer.readInt();
            receivables.clear();
            for (int i = 0; i < size; ++i) {
                receivables.add(buffer.readResourceLocation());
            }
        });
    }

    static NetworkManager.Side side(PacketFlow flow) {
        return flow.isClientbound() ? NetworkManager.Side.S2C : (flow.isServerbound() ? NetworkManager.Side.C2S : null);
    }

    static {
        EventBusesHooksImpl.whenAvailable("architectury", bus -> bus.addListener(NetworkManagerImpl::registerPackets));
    }
}

