/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.api.client.pause;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenHolder.class);
    private final Screen screen;

    private ScreenHolder(Screen screen) {
        this.screen = screen;
    }

    public static ScreenHolder of(Screen screen) {
        return new ScreenHolder(screen);
    }

    public final Screen unsafeScreenAccess() {
        return this.screen;
    }

    public ImmutableCollection<Renderable> renderables() {
        return ImmutableList.copyOf((Collection)this.screen.renderables);
    }

    public ImmutableCollection<NarratableEntry> narratables() {
        return ImmutableList.copyOf((Collection)this.screen.narratables);
    }

    public ImmutableCollection<GuiEventListener> children() {
        return ImmutableList.copyOf((Collection)this.screen.children);
    }

    public int getWidth() {
        return this.screen.width;
    }

    public int getHeight() {
        return this.screen.height;
    }

    public Font font() {
        return Minecraft.getInstance().font;
    }

    public ItemRenderer itemRenderer() {
        return Minecraft.getInstance().getItemRenderer();
    }
}

