/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.spawners;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnerBehaviourModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpawnerBehaviourModifier.class);
    private final BaseSpawner baseSpawner;
    private int ticks = 0;

    public SpawnerBehaviourModifier(BaseSpawner baseSpawner) {
        this.baseSpawner = baseSpawner;
    }

    public void onTick(ServerLevel serverLevel, BlockPos blockPos) {
        if (this.ticks > 40) {
            this.attemptTorchDestroy(serverLevel, blockPos);
            this.ticks = 0;
        } else {
            ++this.ticks;
        }
    }

    private void attemptTorchDestroy(ServerLevel serverLevel, BlockPos blockPos) {
        LOGGER.info("Attempting to destroy torches around spawner at " + blockPos);
        AABB aabb = new AABB(blockPos).inflate(2.5, 3.0, 2.5);
        Stream blockPosStream = BlockPos.betweenClosedStream((AABB)aabb);
        blockPosStream.forEach(pos -> {
            if (serverLevel.getBlockState(pos).getLightEmission() > 0) {
                serverLevel.destroyBlock(pos, true);
                serverLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0);
            }
        });
    }
}

