/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.waterlogging;

import com.mojang.serialization.Codec;
import dev.ftb.packcompanion.registry.StructureProcessorRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WaterLoggingFixProcessor
extends StructureProcessor {
    private static final WaterLoggingFixProcessor INSTANCE = new WaterLoggingFixProcessor();
    public static final Codec<WaterLoggingFixProcessor> CODEC = Codec.unit(() -> INSTANCE);

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo original, StructureTemplate.StructureBlockInfo after, StructurePlaceSettings structurePlaceSettings) {
        if (!after.state().isAir()) {
            this.getWriter(levelReader).ifPresent(writer -> {
                if (after.state().getFluidState().isEmpty() && after.state().getBlock() != Blocks.WATER && levelReader.hasChunkAt(after.pos()) && levelReader.getBlockState(after.pos()).getFluidState().is((Fluid)Fluids.WATER)) {
                    writer.setBlock(after.pos(), after.state(), 3);
                }
            });
        }
        return after;
    }

    private Optional<LevelWriter> getWriter(LevelReader reader) {
        if (reader instanceof WorldGenRegion) {
            WorldGenRegion wg = (WorldGenRegion)reader;
            return Optional.of(wg);
        }
        if (reader instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)reader;
            return Optional.of(sl);
        }
        return Optional.empty();
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)StructureProcessorRegistry.WATER_LOGGING_FIX_PROCESSOR.get();
    }
}

