/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.neoforge.integrations.jer;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.packcompanion.PackCompanionExpectPlatform;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jeresources.api.IJERAPI;
import jeresources.api.IJERPlugin;
import jeresources.api.JERPlugin;
import jeresources.util.LogHelper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JERPlugin
public class JERIntegration
implements IJERPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(JERIntegration.class);

    public void receive(IJERAPI ijerapi) {
        LOGGER.info("Loading Better Loot JER Integration");
        Path extendedLootJsonPath = PackCompanionExpectPlatform.getGameDirectory().resolve("data/ftbpc/jer_extended_loot.json");
        if (Files.notExists(extendedLootJsonPath, new LinkOption[0])) {
            LOGGER.warn("jer_extended_loot.json does not exist, skipping");
            return;
        }
        try {
            String s = Files.readString(extendedLootJsonPath);
            JsonElement jsonElement = JsonParser.parseString((String)s);
            List tables = (List)((Pair)Tables.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))).getFirst();
            for (Tables table : tables) {
                ijerapi.getDungeonRegistry().registerCategory(table.name(), table.displayName());
                for (String chest : table.chests()) {
                    try {
                        ijerapi.getDungeonRegistry().getClass().getMethod("registerChest", String.class, ResourceLocation.class).invoke((Object)ijerapi.getDungeonRegistry(), table.name(), new ResourceLocation(chest));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        LOGGER.error("Failed to register chest: " + chest, (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load jer_extended_loot.json", (Throwable)e);
        }
    }

    public static void loadJerPlugins(IJERAPI instance) {
        Type pluginAnnotation = Type.getType(JERPlugin.class);
        List allScanData = ModList.get().getAllScanData();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), pluginAnnotation)) continue;
                try {
                    Class<?> clazz = Class.forName(a.clazz().getClassName());
                    IJERPlugin plugin = (IJERPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    plugin.receive(instance);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LogHelper.warn((String)("Failed to set: {}" + a.clazz().getClassName() + "." + a.memberName()), (Object[])new Object[0]);
                }
            }
        }
    }

    public record Tables(String name, String displayName, List<String> chests) {
        public static final Codec<Tables> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(Tables::name), (App)Codec.STRING.fieldOf("displayName").forGetter(Tables::displayName), (App)Codec.STRING.listOf().fieldOf("chests").forGetter(Tables::chests)).apply((Applicative)inst, Tables::new));
        public static final Codec<List<Tables>> LIST_CODEC = CODEC.listOf();
    }
}

