/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.neoforge.mixin.features.bedtime;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    public ServerPlayerMixin(Level arg, BlockPos arg2, float f, GameProfile gameProfile) {
        super(arg, arg2, f, gameProfile);
    }

    @Shadow
    protected abstract boolean bedInRange(BlockPos var1, Direction var2);

    @Shadow
    protected abstract boolean bedBlocked(BlockPos var1, Direction var2);

    @Shadow
    public abstract void setRespawnPosition(ResourceKey<Level> var1, @Nullable BlockPos var2, float var3, boolean var4, boolean var5);

    @Shadow
    public abstract boolean isCreative();

    @Shadow
    public abstract void displayClientMessage(Component var1, boolean var2);

    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(method={"startSleepInBed(Lnet/minecraft/core/BlockPos;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="RETURN")}, cancellable=true)
    public void startSleepInBed(BlockPos blockPos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> callback) {
        Either returnValue = (Either)callback.getReturnValue();
        Optional<BlockPos> optAt = Optional.of(blockPos);
        Direction direction = (Direction)this.serverLevel().getBlockState(blockPos).getValue((Property)HorizontalDirectionalBlock.FACING);
        if (returnValue.left().isPresent() && returnValue.left().get() == Player.BedSleepingProblem.NOT_POSSIBLE_HERE) {
            if (!this.bedInRange(blockPos, direction)) {
                callback.setReturnValue((Object)Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY));
            }
            if (this.bedBlocked(blockPos, direction)) {
                callback.setReturnValue((Object)Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED));
            }
            this.setRespawnPosition((ResourceKey<Level>)this.level().dimension(), blockPos, this.getYRot(), false, true);
            if (!EventHooks.fireSleepingTimeCheck((Player)this, optAt)) {
                callback.setReturnValue((Object)Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW));
                return;
            }
            if (!this.isCreative()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockPos);
                List list = this.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x() - 8.0, vec3.y() - 5.0, vec3.z() - 8.0, vec3.x() + 8.0, vec3.y() + 5.0, vec3.z() + 8.0), arg -> arg.isPreventingPlayerRest((Player)this));
                if (!list.isEmpty()) {
                    callback.setReturnValue((Object)Either.left((Object)Player.BedSleepingProblem.NOT_SAFE));
                    return;
                }
            }
            Either either = super.startSleepInBed(blockPos).ifRight(arg -> {
                this.awardStat(Stats.SLEEP_IN_BED);
                CriteriaTriggers.SLEPT_IN_BED.trigger((ServerPlayer)this);
            });
            if (!this.serverLevel().canSleepThroughNights()) {
                this.displayClientMessage((Component)Component.translatable((String)"sleep.not_possible"), true);
            }
            ((ServerLevel)this.level()).updateSleepingPlayerList();
            callback.setReturnValue((Object)either);
            return;
        }
        callback.setReturnValue((Object)((Either)callback.getReturnValue()));
    }
}

