/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge;

import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.UUID;
import me.lucko.spark.common.command.sender.AbstractCommandSender;
import me.lucko.spark.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import me.lucko.spark.neoforge.plugin.NeoForgeSparkPlugin;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.world.entity.player.Player;

public class NeoForgeCommandSender
extends AbstractCommandSender<CommandSource> {
    private final NeoForgeSparkPlugin plugin;

    public NeoForgeCommandSender(CommandSource source, NeoForgeSparkPlugin plugin) {
        super(source);
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        if (this.delegate instanceof Player) {
            return ((Player)this.delegate).getGameProfile().getName();
        }
        if (this.delegate instanceof MinecraftServer) {
            return "Console";
        }
        if (this.delegate instanceof RconConsoleSource) {
            return "RCON Console";
        }
        return "unknown:" + ((CommandSource)this.delegate).getClass().getSimpleName();
    }

    @Override
    public UUID getUniqueId() {
        if (this.delegate instanceof Player) {
            return ((Player)this.delegate).getUUID();
        }
        return null;
    }

    @Override
    public void sendMessage(me.lucko.spark.lib.adventure.text.Component message) {
        MutableComponent component = Component.Serializer.fromJson((JsonElement)GsonComponentSerializer.gson().serializeToTree(message));
        Objects.requireNonNull(component, "component");
        ((CommandSource)this.delegate).sendSystemMessage((Component)component);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.plugin.hasPermission((CommandSource)this.delegate, permission);
    }
}

