/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import com.demonwav.mcdev.annotations.Translatable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import traben.entity_texture_features.ETF;

public class TConfigScreen
extends Screen {
    private final boolean showBackButton;
    protected Screen parent;
    protected Runnable resetDefaultValuesRunnable = null;
    protected Runnable undoChangesRunnable = null;

    protected TConfigScreen(@Translatable String title, Screen parent, boolean showBackButton) {
        super((Component)Component.translatable((String)title));
        this.parent = parent;
        this.showBackButton = showBackButton;
    }

    protected Component getBackButtonText() {
        return CommonComponents.GUI_BACK;
    }

    protected void init() {
        if (this.showBackButton) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getBackButtonText(), button -> this.onClose()).bounds((int)((double)this.width * 0.7), (int)((double)this.height * 0.9), (int)((double)this.width * 0.2), 20).build());
        }
        if (this.resetDefaultValuesRunnable != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)ETF.getTextFromTranslation("dataPack.validation.reset"), button -> {
                this.resetDefaultValuesRunnable.run();
                this.rebuildWidgets();
            }).bounds((int)((double)this.width * 0.4), (int)((double)this.height * 0.9), (int)((double)this.width * 0.22), 20).build());
        }
        if (this.undoChangesRunnable != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.nullToEmpty((String)"Undo changes"), button -> {
                this.undoChangesRunnable.run();
                this.rebuildWidgets();
            }).bounds((int)((double)this.width * 0.1), (int)((double)this.height * 0.9), (int)((double)this.width * 0.2), 20).build());
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.pose().pushPose();
        int topy = (int)((double)this.height * 0.15);
        int bottomy = (int)((double)this.height * 0.85);
        guiGraphics.pose().translate(0.0f, 0.0f, -100.0f);
        guiGraphics.setColor(0.15f, 0.15f, 0.15f, 1.0f);
        guiGraphics.blit(BACKGROUND_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.width, this.height, 32, 32);
        guiGraphics.fillGradient(RenderType.gui(), 0, topy, this.width, topy + 4, -16777216, 0, 0);
        guiGraphics.fillGradient(RenderType.gui(), 0, bottomy - 4, this.width, bottomy, 0, -16777216, 0);
        guiGraphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.blit(BACKGROUND_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.width, topy, 32, 32);
        guiGraphics.blit(BACKGROUND_LOCATION, 0, bottomy, 0, 0.0f, 0.0f, this.width, topy, 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.pose().popPose();
    }

    public void renderDirtBackground(GuiGraphics guiGraphics) {
    }
}

