/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import com.demonwav.mcdev.annotations.Translatable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import traben.tconfig.gui.TConfigEntryListWidget;
import traben.tconfig.gui.TConfigScreen;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigScreenList
extends TConfigScreen {
    private final TConfigEntry[] options;
    private final Align align;
    protected boolean fullWidthBackgroundEvenIfSmaller = false;
    private Renderable renderFeature = null;

    public TConfigScreenList(@Translatable String title, Screen parent, TConfigEntry[] options, Runnable resetValuesToDefault, Runnable undoChanges, Align align) {
        super(title, parent, true);
        this.options = options;
        this.parent = parent;
        this.resetDefaultValuesRunnable = resetValuesToDefault;
        this.undoChangesRunnable = undoChanges;
        this.align = align;
    }

    public TConfigScreenList(@Translatable String title, Screen parent, TConfigEntry[] options, Runnable resetValuesToDefault, Runnable undoChanges) {
        this(title, parent, options, resetValuesToDefault, undoChanges, Align.CENTER);
    }

    public void setRenderFeature(Renderable renderFeature) {
        this.renderFeature = renderFeature;
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.renderFeature != null) {
            this.renderFeature.render(context, mouseX, mouseY);
        }
    }

    public void setWidgetBackgroundToFullWidth() {
        this.fullWidthBackgroundEvenIfSmaller = true;
    }

    @Override
    protected void init() {
        int width;
        super.init();
        this.addRenderableWidget((GuiEventListener)new TConfigEntryListWidget(width, (int)((double)this.height * 0.7), (int)((double)this.height * 0.15), switch (this.align.ordinal()) {
            case 0 -> {
                width = (int)((double)this.width * 0.3);
                yield (int)((double)this.width * 0.1);
            }
            case 2 -> {
                width = (int)((double)this.width * 0.3);
                yield (int)((double)this.width * 0.6);
            }
            default -> {
                width = this.width;
                yield 0;
            }
        }, 24, this.options));
    }

    public static interface Renderable {
        public void render(GuiGraphics var1, int var2, int var3);
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

