/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class StringListProperty
extends TeamProperty<List<String>> {
    public StringListProperty(ResourceLocation id, Supplier<List<String>> def) {
        super(id, def);
    }

    public StringListProperty(ResourceLocation id, List<String> def) {
        this(id, () -> def);
    }

    static StringListProperty fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new StringListProperty(id, buf.readList(b -> b.readUtf(Short.MAX_VALUE)));
    }

    @Override
    public TeamPropertyType<List<String>> getType() {
        return TeamPropertyType.STRING_LIST;
    }

    @Override
    public Optional<List<String>> fromString(String string) {
        return string.length() > 2 && string.startsWith("[") && string.endsWith("]") ? Optional.of(new ArrayList<String>(Arrays.asList(string.substring(1, string.length() - 1).split("\t")))) : Optional.empty();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeCollection((Collection)this.getDefaultValue(), FriendlyByteBuf::writeUtf);
    }

    @Override
    public String toString(List<String> value) {
        return "[" + String.join((CharSequence)"\t", value) + "]";
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<List<String>> value) {
        config.addList(this.id.getPath(), (List)value.value, (ConfigValue)new StringConfig(), (Object)"");
    }

    @Override
    public Tag toNBT(List<String> value) {
        ListTag res = new ListTag();
        value.forEach(s -> res.add((Object)StringTag.valueOf((String)s)));
        return res;
    }

    @Override
    public Optional<List<String>> fromNBT(Tag tag) {
        ArrayList res = new ArrayList();
        if (tag instanceof ListTag) {
            ListTag l = (ListTag)tag;
            l.forEach(t -> res.add(t.getAsString()));
            return Optional.of(res);
        }
        return Optional.empty();
    }
}

