/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerGUIOperationMessage
extends BaseC2SMessage {
    private final Operation op;
    private final List<UUID> targets;

    public PlayerGUIOperationMessage(Operation op, UUID target) {
        this.op = op;
        this.targets = List.of(target);
    }

    public PlayerGUIOperationMessage(Operation op, Collection<GameProfile> targets) {
        this.op = op;
        this.targets = targets.stream().map(GameProfile::getId).toList();
    }

    public PlayerGUIOperationMessage(FriendlyByteBuf buf) {
        this.op = (Operation)buf.readEnum(Operation.class);
        this.targets = new ArrayList<UUID>();
        int n = buf.readVarInt();
        for (int i = 0; i < n; ++i) {
            this.targets.add(buf.readUUID());
        }
    }

    public MessageType getType() {
        return FTBTeamsNet.PLAYER_GUI_OPERATION;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.op);
        buf.writeVarInt(this.targets.size());
        this.targets.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeUUID(arg_0));
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UUID senderId = context.getPlayer().getUUID();
        FTBTeamsAPI.api().getManager().getTeamForPlayerID(senderId).ifPresent(team -> {
            if (team instanceof PartyTeam) {
                PartyTeam partyTeam = (PartyTeam)team;
                TeamRank senderRank = partyTeam.getRankForPlayer(serverPlayer.getUUID());
                this.targets.forEach(target -> this.processTarget(serverPlayer, senderRank, partyTeam, (UUID)target));
            }
        });
    }

    private void processTarget(ServerPlayer sourcePlayer, TeamRank senderRank, PartyTeam partyTeam, UUID targetId) {
        if (this.op.requireSameTeam() && !FTBTeamsAPI.api().getManager().arePlayersInSameTeam(sourcePlayer.getUUID(), targetId)) {
            return;
        }
        TeamRank targetRank = partyTeam.getRankForPlayer(targetId);
        FTBTeams.LOGGER.debug("received teams operation msg {} from {} (rank {}), team {}, target {} (rank {})", (Object)this.op, (Object)sourcePlayer.getUUID(), (Object)senderRank, (Object)partyTeam.getName().getString(), (Object)targetId, (Object)targetRank);
        try {
            List<GameProfile> targetProfile = List.of(new GameProfile(targetId, ""));
            switch (this.op) {
                case KICK: {
                    if (senderRank.getPower() <= targetRank.getPower()) break;
                    partyTeam.kick(sourcePlayer.createCommandSourceStack(), targetProfile);
                    break;
                }
                case PROMOTE: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER) || !targetRank.isAtLeast(TeamRank.MEMBER)) break;
                    partyTeam.promote(sourcePlayer, targetProfile);
                    break;
                }
                case DEMOTE: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER) || !targetRank.isAtLeast(TeamRank.OFFICER)) break;
                    partyTeam.demote(sourcePlayer, targetProfile);
                    break;
                }
                case TRANSFER_OWNER: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER)) break;
                    ServerPlayer p = sourcePlayer.getServer().getPlayerList().getPlayer(targetId);
                    if (p != null) {
                        partyTeam.transferOwnership(sourcePlayer.createCommandSourceStack(), p.getGameProfile());
                    }
                    break;
                }
                case LEAVE: {
                    partyTeam.leave(sourcePlayer.getUUID());
                    break;
                }
                case INVITE: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER)) break;
                    ServerPlayer p = sourcePlayer.getServer().getPlayerList().getPlayer(targetId);
                    if (p != null) {
                        partyTeam.invite(sourcePlayer, List.of(p.getGameProfile()));
                    }
                    break;
                }
                case ADD_ALLY: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER) || !targetRank.isAtLeast(TeamRank.NONE)) break;
                    partyTeam.addAlly(sourcePlayer.createCommandSourceStack(), targetProfile);
                    break;
                }
                case REMOVE_ALLY: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER) || !targetRank.isAtLeast(TeamRank.ALLY)) break;
                    partyTeam.removeAlly(sourcePlayer.createCommandSourceStack(), targetProfile);
                }
            }
        }
        catch (CommandSyntaxException e) {
            sourcePlayer.displayClientMessage((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.RED), false);
        }
    }

    public static enum Operation {
        PROMOTE(true),
        DEMOTE(true),
        LEAVE(true),
        KICK(true),
        TRANSFER_OWNER(true),
        INVITE(false),
        ADD_ALLY(false),
        REMOVE_ALLY(false);

        private final boolean requireSameTeam;

        private Operation(boolean requireSameTeam) {
            this.requireSameTeam = requireSameTeam;
        }

        boolean requireSameTeam() {
            return this.requireSameTeam;
        }

        public void sendMessage(KnownClientPlayer target) {
            new PlayerGUIOperationMessage(this, target.id()).sendToServer();
        }
    }
}

