/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class EmojiFromTwitmoji
extends Emoji {
    public SimpleTexture img;
    public ResourceLocation resourceLocation = loading_texture;

    @Override
    public void checkLoad() {
        if (this.img != null) {
            return;
        }
        this.img = new DownloadImageData(new File("emojiful/cache/" + this.name + "-" + this.version), "https://raw.githubusercontent.com/iamcal/emoji-data/master/img-twitter-64/" + this.location, loading_texture);
        this.resourceLocation = new ResourceLocation("emojiful", "texures/emoji/" + this.location.toLowerCase() + "_" + this.version);
        Minecraft.getInstance().getTextureManager().register(this.resourceLocation, (AbstractTexture)this.img);
    }

    @Override
    public ResourceLocation getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.releaseId();
            this.deleteOldTexture = false;
        }
        return this.resourceLocation;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public class DownloadImageData
    extends SimpleTexture {
        private final File cacheFile;
        private final String imageUrl;
        private NativeImage nativeImage;
        private Thread imageThread;
        private boolean textureUploaded;

        public DownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
            this.imageUrl = imageUrlIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.nativeImage != null) {
                if (this.location != null) {
                    this.releaseId();
                }
                TextureUtil.prepareImage((int)super.getId(), (int)this.nativeImage.getWidth(), (int)this.nativeImage.getHeight());
                this.nativeImage.upload(0, 0, 0, true);
                this.textureUploaded = true;
            }
        }

        private void setImage(NativeImage nativeImageIn) {
            Minecraft.getInstance().execute(() -> {
                this.textureUploaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
                } else {
                    this.upload(nativeImageIn);
                }
            });
        }

        private void upload(NativeImage imageIn) {
            TextureUtil.prepareImage((int)this.getId(), (int)imageIn.getWidth(), (int)imageIn.getHeight());
            imageIn.upload(0, 0, 0, true);
        }

        @Nullable
        private NativeImage loadTexture(InputStream inputStreamIn) {
            NativeImage nativeimage = null;
            try {
                nativeimage = NativeImage.read((InputStream)inputStreamIn);
            }
            catch (IOException ioexception) {
                Constants.LOG.warn("Error while loading the skin texture", (Throwable)ioexception);
            }
            return nativeimage;
        }

        public void load(ResourceManager resourceManager) throws IOException {
            if (this.imageThread == null) {
                if (this.cacheFile != null && this.cacheFile.isFile()) {
                    try {
                        FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                        this.setImage(this.loadTexture(fileinputstream));
                    }
                    catch (IOException ioexception) {
                        this.loadTextureFromServer();
                    }
                } else {
                    this.loadTextureFromServer();
                }
            }
        }

        protected void loadTextureFromServer() {
            this.imageThread = new Thread("Emojiful Texture Downloader #" + Emoji.threadDownloadCounter.incrementAndGet()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpURLConnection httpurlconnection = null;
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(DownloadImageData.this.imageUrl).openConnection(Minecraft.getInstance().getProxy());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputStream;
                            int contentLength = httpurlconnection.getContentLength();
                            if (DownloadImageData.this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)DownloadImageData.this.cacheFile);
                                inputStream = new FileInputStream(DownloadImageData.this.cacheFile);
                            } else {
                                inputStream = httpurlconnection.getInputStream();
                            }
                            DownloadImageData.this.setImage(DownloadImageData.this.loadTexture(inputStream));
                        } else {
                            EmojiFromTwitmoji.this.resourceLocation = Emoji.noSignal_texture;
                            EmojiFromTwitmoji.this.deleteOldTexture = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EmojiFromTwitmoji.this.resourceLocation = Emoji.error_texture;
                        EmojiFromTwitmoji.this.deleteOldTexture = true;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }
            };
            this.imageThread.setDaemon(true);
            this.imageThread.start();
        }
    }
}

