/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.platform.Services;
import com.hrznstudio.emojiful.util.EmojiUtil;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EmojiFontRenderer
extends Font {
    public static final Vector3f SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, 0.03f);
    public static LoadingCache<String, Pair<String, HashMap<Integer, Emoji>>> RECENT_STRINGS = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Pair<String, HashMap<Integer, Emoji>>>(){

        public Pair<String, HashMap<Integer, Emoji>> load(String key) throws Exception {
            return EmojiFontRenderer.getEmojiFormattedString(key);
        }
    });
    private TextureAtlasSprite sprite;

    public EmojiFontRenderer(Font fontRenderer) {
        super(fontRenderer.fonts, fontRenderer.filterFishyGlyphs);
    }

    public static Pair<String, HashMap<Integer, Emoji>> getEmojiFormattedString(String text) {
        LinkedHashMap<Integer, Emoji> emojis = new LinkedHashMap<Integer, Emoji>();
        if (Services.CONFIG.renderEmoji() && !StringUtil.isNullOrEmpty((String)text)) {
            String unformattedText = ChatFormatting.stripFormatting((String)text);
            if (StringUtil.isNullOrEmpty((String)unformattedText)) {
                return Pair.of((Object)text, emojis);
            }
            for (Emoji emoji : Constants.EMOJI_LIST) {
                Pattern pattern = emoji.getRegex();
                Matcher matcher = pattern.matcher(unformattedText);
                while (matcher.find()) {
                    if (matcher.group().isEmpty()) continue;
                    String emojiText = matcher.group();
                    int index = text.indexOf(emojiText);
                    emojis.put(index, emoji);
                    LinkedHashMap<Integer, Emoji> clean = new LinkedHashMap<Integer, Emoji>();
                    for (Integer integer : new ArrayList(((HashMap)emojis).keySet())) {
                        if (integer <= index) continue;
                        Emoji e = (Emoji)((HashMap)emojis).get(integer);
                        emojis.remove(integer);
                        clean.put(integer - emojiText.length() + 1, e);
                    }
                    emojis.putAll(clean);
                    unformattedText = unformattedText.replaceFirst(Pattern.quote(emojiText), "\u2603");
                    text = text.replaceFirst("(?i)" + Pattern.quote(emojiText), "\u2603");
                }
            }
        }
        return Pair.of((Object)text, emojis);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public int width(String text) {
        if (text != null) {
            try {
                text = (String)((Pair)RECENT_STRINGS.get((Object)text)).getKey();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.width(text);
    }

    public int width(FormattedText textProperties) {
        return this.width(textProperties.getString());
    }

    public int width(FormattedCharSequence processor) {
        StringBuilder builder = new StringBuilder();
        processor.accept((p_accept_1_, p_accept_2_, ch) -> {
            builder.append((char)ch);
            return true;
        });
        return this.width(builder.toString());
    }

    public void renderChar(BakedGlyph $$0, boolean $$1, boolean $$2, float $$3, float $$4, float $$5, Matrix4f $$6, VertexConsumer $$7, float $$8, float $$9, float $$10, float $$11, int $$12) {
        super.renderChar($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8, $$9, $$10, $$11, $$12);
    }

    public float renderText(String text, float x, float y, int color, boolean isShadow, Matrix4f matrix, MultiBufferSource buffer, Font.DisplayMode displayMode, int colorBackgroundIn, int packedLight) {
        if (text.isEmpty()) {
            return 0.0f;
        }
        HashMap emojis = new LinkedHashMap<Integer, Emoji>();
        try {
            Pair cache = (Pair)RECENT_STRINGS.get((Object)text);
            text = (String)cache.getLeft();
            emojis = (HashMap)cache.getRight();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        EmojiCharacterRenderer fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, isShadow, matrix, displayMode == Font.DisplayMode.SEE_THROUGH, packedLight);
        StringDecomposer.iterateFormatted((String)text, (Style)Style.EMPTY, (FormattedCharSink)fontrenderer$characterrenderer);
        return fontrenderer$characterrenderer.finish(colorBackgroundIn, x);
    }

    public int drawInBatch(FormattedCharSequence reorderingProcessor, float x, float y, int color, boolean isShadow, Matrix4f matrix, MultiBufferSource buffer, Font.DisplayMode displayMode, int colorBackgroundIn, int packedLight) {
        if (reorderingProcessor != null) {
            String text;
            StringBuilder builder = new StringBuilder();
            if (reorderingProcessor != null) {
                reorderingProcessor.accept((p_accept_1_, p_accept_2_, ch) -> {
                    builder.append((char)ch);
                    return true;
                });
            }
            if ((text = builder.toString()).length() > 0) {
                EmojiCharacterRenderer fontrenderer$characterrenderer;
                color = (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
                LinkedHashMap<Integer, Emoji> emojis = new LinkedHashMap();
                try {
                    Pair cache = (Pair)RECENT_STRINGS.get((Object)text);
                    text = (String)cache.getLeft();
                    emojis = (HashMap)cache.getRight();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                ArrayList processors = new ArrayList();
                LinkedHashMap finalEmojis = emojis;
                AtomicInteger cleanPos = new AtomicInteger();
                AtomicBoolean ignore = new AtomicBoolean(false);
                reorderingProcessor.accept((pos, style, ch) -> {
                    if (!ignore.get()) {
                        if (finalEmojis.get(cleanPos.get()) == null) {
                            processors.add(new CharacterProcessor(cleanPos.getAndIncrement(), style, ch));
                        } else {
                            processors.add(new CharacterProcessor(cleanPos.get(), style, 32));
                            ignore.set(true);
                            return true;
                        }
                    }
                    if (ignore.get() && ch == 58) {
                        ignore.set(false);
                        cleanPos.getAndIncrement();
                    }
                    return true;
                });
                Matrix4f matrix4f = new Matrix4f((Matrix4fc)matrix);
                if (isShadow) {
                    fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, true, matrix4f, displayMode == Font.DisplayMode.SEE_THROUGH, packedLight);
                    FormattedCharSequence.fromList(processors).accept((FormattedCharSink)fontrenderer$characterrenderer);
                    fontrenderer$characterrenderer.finish(colorBackgroundIn, x);
                    matrix4f.translate((Vector3fc)SHADOW_OFFSET);
                }
                fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, false, matrix4f, displayMode == Font.DisplayMode.SEE_THROUGH, packedLight);
                FormattedCharSequence.fromList(processors).accept((FormattedCharSink)fontrenderer$characterrenderer);
                return (int)fontrenderer$characterrenderer.finish(colorBackgroundIn, x);
            }
        }
        return super.drawInBatch(reorderingProcessor, x, y, color, isShadow, matrix, buffer, displayMode, colorBackgroundIn, packedLight);
    }

    class EmojiCharacterRenderer
    implements FormattedCharSink {
        final MultiBufferSource buffer;
        private final boolean dropShadow;
        private final float dimFactor;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final Matrix4f matrix;
        private final boolean seeThrough;
        private final int packedLight;
        private float x;
        private final float y;
        private final HashMap<Integer, Emoji> emojis;
        @Nullable
        private List<BakedGlyph.Effect> effects;

        public EmojiCharacterRenderer(HashMap<Integer, Emoji> emojis, MultiBufferSource p_i232250_2_, float p_i232250_3_, float p_i232250_4_, int p_i232250_5_, boolean p_i232250_6_, Matrix4f p_i232250_7_, boolean p_i232250_8_, int p_i232250_9_) {
            this.buffer = p_i232250_2_;
            this.emojis = emojis;
            this.x = p_i232250_3_;
            this.y = p_i232250_4_;
            this.dropShadow = p_i232250_6_;
            this.dimFactor = p_i232250_6_ ? 0.25f : 1.0f;
            this.r = (float)(p_i232250_5_ >> 16 & 0xFF) / 255.0f * this.dimFactor;
            this.g = (float)(p_i232250_5_ >> 8 & 0xFF) / 255.0f * this.dimFactor;
            this.b = (float)(p_i232250_5_ & 0xFF) / 255.0f * this.dimFactor;
            this.a = (float)(p_i232250_5_ >> 24 & 0xFF) / 255.0f;
            this.matrix = p_i232250_7_;
            this.seeThrough = p_i232250_8_;
            this.packedLight = p_i232250_9_;
        }

        private void addEffect(BakedGlyph.Effect p_238442_1_) {
            if (this.effects == null) {
                this.effects = Lists.newArrayList();
            }
            this.effects.add(p_238442_1_);
        }

        public boolean accept(int pos, Style style, int charInt) {
            FontSet font = EmojiFontRenderer.this.getFontSet(style.getFont());
            if (Services.CONFIG.renderEmoji() && this.emojis.get(pos) != null) {
                Emoji emoji = this.emojis.get(pos);
                if (emoji != null) {
                    if (!this.dropShadow) {
                        EmojiUtil.renderEmoji(emoji, this.x, this.y, this.matrix, this.buffer, this.packedLight);
                    }
                    this.x += 10.0f;
                }
            } else {
                float f7;
                float f2;
                float f1;
                float f;
                GlyphInfo iglyph = font.getGlyphInfo(charInt, EmojiFontRenderer.this.filterFishyGlyphs);
                BakedGlyph texturedglyph = style.isObfuscated() && charInt != 32 ? font.getRandomGlyph(iglyph) : font.getGlyph(charInt);
                boolean flag = style.isBold();
                float f3 = this.a;
                TextColor color = style.getColor();
                if (color != null) {
                    int i = color.getValue();
                    f = (float)(i >> 16 & 0xFF) / 255.0f * this.dimFactor;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f * this.dimFactor;
                    f2 = (float)(i & 0xFF) / 255.0f * this.dimFactor;
                } else {
                    f = this.r;
                    f1 = this.g;
                    f2 = this.b;
                }
                if (!(texturedglyph instanceof EmptyGlyph)) {
                    float f5 = flag ? iglyph.getBoldOffset() : 0.0f;
                    float f4 = this.dropShadow ? iglyph.getShadowOffset() : 0.0f;
                    VertexConsumer ivertexbuilder = this.buffer.getBuffer(texturedglyph.renderType(this.seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL));
                    EmojiFontRenderer.this.renderChar(texturedglyph, flag, style.isItalic(), f5, this.x + f4, this.y + f4, this.matrix, ivertexbuilder, f, f1, f2, f3, this.packedLight);
                }
                float f6 = iglyph.getAdvance(flag);
                float f4 = f7 = this.dropShadow ? 1.0f : 0.0f;
                if (style.isStrikethrough()) {
                    this.addEffect(new BakedGlyph.Effect(this.x + f7 - 1.0f, this.y + f7 + 4.5f, this.x + f7 + f6, this.y + f7 + 4.5f - 1.0f, 0.01f, f, f1, f2, f3));
                }
                if (style.isUnderlined()) {
                    this.addEffect(new BakedGlyph.Effect(this.x + f7 - 1.0f, this.y + f7 + 9.0f, this.x + f7 + f6, this.y + f7 + 9.0f - 1.0f, 0.01f, f, f1, f2, f3));
                }
                this.x += f6;
                return true;
            }
            return true;
        }

        public float finish(int p_238441_1_, float p_238441_2_) {
            if (p_238441_1_ != 0) {
                float f = (float)(p_238441_1_ >> 24 & 0xFF) / 255.0f;
                float f1 = (float)(p_238441_1_ >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(p_238441_1_ >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(p_238441_1_ & 0xFF) / 255.0f;
                this.addEffect(new BakedGlyph.Effect(p_238441_2_ - 1.0f, this.y + 9.0f, this.x + 1.0f, this.y - 1.0f, 0.01f, f1, f2, f3, f));
            }
            if (this.effects != null) {
                FontSet fontSet = EmojiFontRenderer.this.getFontSet(Style.DEFAULT_FONT);
                BakedGlyph texturedglyph = fontSet.whiteGlyph();
                VertexConsumer ivertexbuilder = this.buffer.getBuffer(texturedglyph.renderType(this.seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL));
                for (BakedGlyph.Effect texturedglyph$effect : this.effects) {
                    texturedglyph.renderEffect(texturedglyph$effect, this.matrix, ivertexbuilder, this.packedLight);
                }
            }
            return this.x;
        }
    }

    class CharacterProcessor
    implements FormattedCharSequence {
        public final int pos;
        public final Style style;
        public final int character;

        CharacterProcessor(int pos, Style style, int character) {
            this.pos = pos;
            this.style = style;
            this.character = character;
        }

        public boolean accept(FormattedCharSink iCharacterConsumer) {
            return iCharacterConsumer.accept(this.pos, this.style, this.character);
        }
    }
}

