/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.init.ModStructurePieceTypes;
import xiroc.dungeoncrawl.init.ModStructureTypes;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;

@Mod(value="dungeoncrawl")
public class DungeonCrawl {
    public static final String MOD_ID = "dungeoncrawl";
    public static final String NAME = "Dungeon Crawl";
    public static final String VERSION = "2.3.15";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl");
    public static final DeferredRegister<LootItemFunctionType> LOOT_FUNCTION_TYPE = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"dungeoncrawl");
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPE = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"dungeoncrawl");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECE_TYPE = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"dungeoncrawl");

    public DungeonCrawl(IEventBus modEventBus) {
        LOGGER.info("Here we go! Launching Dungeon Crawl {}...", (Object)VERSION);
        LOOT_FUNCTION_TYPE.register(modEventBus);
        STRUCTURE_TYPE.register(modEventBus);
        STRUCTURE_PIECE_TYPE.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        forgeEventBus.addListener(this::onAddReloadListener);
        Loot.init();
        ModStructureTypes.init();
        ModStructurePieceTypes.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup");
        Config.load(FMLPaths.CONFIGDIR.get().resolve("dungeon_crawl.toml"));
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceReloadHandler());
    }

    public static ResourceLocation locate(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation key(ResourceLocation resourceLocation, String baseDirectory, String fileEnding) {
        String path = resourceLocation.getPath();
        return new ResourceLocation(resourceLocation.getNamespace(), path.substring(baseDirectory.length() + 1, path.length() - fileEnding.length()));
    }
}

