/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;

public class DungeonModelBlock {
    public final DungeonModelBlockType type;
    public Vec3i position;
    @Nullable
    private final PropertyHolder[] properties;
    public final boolean hasProperties;
    @Nullable
    public final Integer variation;
    public final Block block;
    @Nullable
    public final ResourceLocation blockName;
    @Nullable
    public ResourceLocation lootTable;

    private DungeonModelBlock(DungeonModelBlockType type, Vec3i position) {
        this(type, position, null, null, Blocks.CAVE_AIR, null);
    }

    private DungeonModelBlock(DungeonModelBlockType type, Vec3i position, @Nullable PropertyHolder[] properties, @Nullable Integer variation, Block block, @Nullable ResourceLocation blockName) {
        this.type = type;
        this.position = position;
        this.properties = properties;
        this.hasProperties = properties != null;
        this.variation = variation;
        this.block = block;
        this.blockName = blockName;
    }

    public static DungeonModelBlock fromBlockState(BlockState state, DungeonModelBlockType type, Vec3i position) {
        Block block;
        ArrayList properties = Lists.newArrayList();
        for (Property property : state.getProperties()) {
            properties.add(new PropertyHolder(property, state.getValue(property)));
        }
        PropertyHolder[] blockProperties = properties.isEmpty() ? null : properties.toArray(new PropertyHolder[0]);
        Integer variation = null;
        ResourceLocation blockName = null;
        if (type == DungeonModelBlockType.CARPET) {
            variation = 0;
            block = state.getBlock();
            blockName = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        } else if (type == DungeonModelBlockType.OTHER) {
            block = state.getBlock();
            blockName = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        } else {
            block = Blocks.CAVE_AIR;
        }
        return new DungeonModelBlock(type, position, blockProperties, variation, block, blockName);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", this.type.toString());
        CompoundTag position = new CompoundTag();
        position.putInt("x", this.position.getX());
        position.putInt("y", this.position.getY());
        position.putInt("z", this.position.getZ());
        tag.put("position", (Tag)position);
        if (this.blockName != null) {
            tag.putString("resourceName", this.blockName.toString());
        }
        if (this.properties != null) {
            ListTag properties = new ListTag();
            for (PropertyHolder holder : this.properties) {
                CompoundTag nbt = new CompoundTag();
                nbt.putString("property", holder.propertyName);
                nbt.putString("value", holder.valueName);
                properties.add((Object)nbt);
            }
            if (properties.size() > 0) {
                tag.put("properties", (Tag)properties);
            }
        }
        if (this.variation != null) {
            tag.putInt("variation", this.variation.intValue());
        }
        return tag;
    }

    public static DungeonModelBlock fromNBT(CompoundTag nbt, Vec3i position) {
        Block block;
        String type;
        if (!nbt.contains("type")) {
            DungeonCrawl.LOGGER.info("Model block does not have a type parameter");
            return new DungeonModelBlock(DungeonModelBlockType.AIR, position);
        }
        if (nbt.contains("position")) {
            CompoundTag pos = nbt.getCompound("position");
            position = new Vec3i(pos.getInt("x"), pos.getInt("y"), pos.getInt("z"));
        }
        if (!DungeonModelBlockType.NAME_TO_TYPE.containsKey((Object)(type = nbt.getString("type")))) {
            DungeonCrawl.LOGGER.warn("Unknown model block type: {}", (Object)type);
            return new DungeonModelBlock(DungeonModelBlockType.AIR, position);
        }
        DungeonModelBlockType blockType = (DungeonModelBlockType)((Object)DungeonModelBlockType.NAME_TO_TYPE.get((Object)type));
        ResourceLocation blockName = null;
        if (nbt.contains("resourceName")) {
            blockName = new ResourceLocation(nbt.getString("resourceName"));
            if (BuiltInRegistries.BLOCK.containsKey(blockName)) {
                block = (Block)BuiltInRegistries.BLOCK.get(blockName);
            } else {
                DungeonCrawl.LOGGER.warn("Unknown block: {}", (Object)blockName);
                block = Blocks.CAVE_AIR;
            }
        } else {
            block = Blocks.CAVE_AIR;
        }
        PropertyHolder[] properties = null;
        if (nbt.contains("properties")) {
            ListTag nbtProperties = nbt.getList("properties", 10);
            properties = new PropertyHolder[nbtProperties.size()];
            for (int i = 0; i < nbtProperties.size(); ++i) {
                CompoundTag data = (CompoundTag)nbtProperties.get(i);
                properties[i] = new PropertyHolder(data.getString("property"), data.getString("value"));
            }
        }
        Integer variation = null;
        if (nbt.contains("variation")) {
            variation = nbt.getInt("variation");
        }
        return new DungeonModelBlock(blockType, position, properties, variation, block, blockName);
    }

    public static DungeonModelBlock fromNBT(CompoundTag nbt) {
        return DungeonModelBlock.fromNBT(nbt, null);
    }

    public BlockPos worldPos(DungeonModel model, Rotation rotation, BlockPos offset) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BlockPos(offset.getX() + model.length - this.position.getZ() - 1, offset.getY() + this.position.getY(), offset.getZ() + this.position.getX());
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(offset.getX() + this.position.getZ(), offset.getY() + this.position.getY(), offset.getZ() + model.width - this.position.getX() - 1);
            case Rotation.CLOCKWISE_180 -> new BlockPos(offset.getX() + model.width - this.position.getX() - 1, offset.getY() + this.position.getY(), offset.getZ() + model.length - this.position.getZ() - 1);
            default -> offset.offset(this.position);
        };
    }

    public BlockState create(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
            }
        }
        return state.rotate(world, pos, rotation);
    }

    public BlockState create(BlockState state) {
        if (this.properties != null) {
            for (PropertyHolder holder : this.properties) {
                state = holder.apply(state);
            }
        }
        return state;
    }

    public Block getBlock() {
        return this.block;
    }

    private static class PropertyHolder {
        public String propertyName;
        public String valueName;
        public Property<?> property;
        public Object value;

        public PropertyHolder(String propertyName, String valueName) {
            this.propertyName = propertyName;
            this.valueName = valueName;
        }

        public PropertyHolder(Property<?> property, Object value) {
            this.property = property;
            this.propertyName = property.getName();
            this.value = value;
            this.valueName = value.toString().toLowerCase(Locale.ROOT);
        }

        public <T extends Comparable<T>> BlockState apply(BlockState state) {
            if (this.property == null) {
                for (Property p : state.getProperties()) {
                    if (!p.getName().equals(this.propertyName)) continue;
                    this.property = p;
                    Optional optional = p.getValue(this.valueName);
                    if (optional.isPresent()) {
                        this.value = optional.get();
                        break;
                    }
                    DungeonCrawl.LOGGER.error("Couldn't parse property {} with value {}", (Object)p.getName(), (Object)this.valueName);
                    break;
                }
            }
            if (state.hasProperty(this.property)) {
                return (BlockState)state.setValue(this.property, (Comparable)this.value);
            }
            return state;
        }
    }
}

