/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FluidState;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.DungeonBlocks;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.DirectionalBlockPos;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.Range;

public final class DungeonModelFeature {
    private final Type type;
    private final Position[] positions;
    private final Range amount;
    @Nullable
    private final DungeonModelFeature followup;

    private DungeonModelFeature(Type type, Position[] positions, Range amount, @Nullable DungeonModelFeature followup) {
        this.type = type;
        this.positions = positions;
        this.amount = amount;
        this.followup = followup;
    }

    public void setup(DungeonModel model, int x, int y, int z, Rotation rotation, List<Instance> features, RandomSource rand) {
        this.setup(model, x, y, z, rotation, features, Lists.newArrayList((Object[])this.positions), rand);
    }

    private void setup(DungeonModel model, int x, int y, int z, Rotation rotation, List<Instance> features, List<Position> positions, RandomSource rand) {
        if (positions.isEmpty()) {
            return;
        }
        int count = this.amount.nextInt(rand);
        if (count >= positions.size()) {
            features.add(new Instance(this.type, (DirectionalBlockPos[])positions.stream().map(pos -> pos.worldPos(x, y, z, rotation, model)).toArray(DirectionalBlockPos[]::new)));
        } else {
            DirectionalBlockPos[] resultingPositions = new DirectionalBlockPos[count];
            for (int i = 0; i < count; ++i) {
                Position pos2 = positions.get(rand.nextInt(positions.size()));
                DirectionalBlockPos position = pos2.worldPos(x, y, z, rotation, model);
                positions.remove(pos2);
                resultingPositions[i] = position;
            }
            features.add(new Instance(this.type, resultingPositions));
        }
        if (this.followup != null && !positions.isEmpty()) {
            this.followup.setup(model, x, y, z, rotation, features, positions, rand);
        }
    }

    private static void placeChest(LevelAccessor world, BlockPos pos, BlockState chest, Theme theme, SecondaryTheme secondaryTheme, int lootLevel, RandomSource rand) {
        world.setBlock(pos, chest, 2);
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity randomizableContainerBlockEntity = (RandomizableContainerBlockEntity)tileEntity;
            Loot.setLoot(world, pos, randomizableContainerBlockEntity, Loot.getLootTable(lootLevel, rand), theme, secondaryTheme, rand);
        }
    }

    public static DungeonModelFeature fromJson(JsonObject object, ResourceLocation file) {
        return DungeonModelFeature.fromJson(object, file, null);
    }

    private static DungeonModelFeature fromJson(JsonObject object, ResourceLocation file, Position[] positions) {
        String type = object.get("type").getAsString();
        if (!Type.TYPES.containsKey((Object)type)) {
            throw new DatapackLoadException("Unknown feature type " + type + " in " + file);
        }
        if (positions == null) {
            JsonArray positionsArray = object.getAsJsonArray("positions");
            positions = new Position[positionsArray.size()];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = Position.fromJson(positionsArray.get(i).getAsJsonObject());
            }
        }
        JsonObject jsonAmount = object.getAsJsonObject("amount");
        Range amount = new Range(jsonAmount.get("min").getAsInt(), jsonAmount.get("max").getAsInt());
        DungeonModelFeature followUp = null;
        if (object.has("follow_up")) {
            followUp = DungeonModelFeature.fromJson(object.getAsJsonObject("follow_up"), file, positions);
        }
        return new DungeonModelFeature((Type)Type.TYPES.get((Object)type), positions, amount, followUp);
    }

    private static interface Type {
        public static final Type CHEST = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                if (bounds.isInside((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.getBlockState(pos.below()).canOcclude()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), theme, secondaryTheme, stage, rand);
                }
            }

            @Override
            public String getName() {
                return "chest";
            }
        };
        public static final Type TNT_CHEST = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                if (bounds.isInside((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.getBlockState(pos.below()).canOcclude()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), theme, secondaryTheme, stage, rand);
                    BlockPos down = pos.below(2);
                    if (!DungeonBuilder.isBlockProtected(world, down) && !world.isEmptyBlock(down)) {
                        world.setBlock(pos.below(2), Blocks.TNT.defaultBlockState(), 2);
                    }
                }
            }

            @Override
            public String getName() {
                return "tnt_chest";
            }
        };
        public static final Type SPAWNER = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                if (bounds.isInside((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.getBlockState(pos.below()).canOcclude()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, pos, rand, theme, secondaryTheme, stage);
                }
            }

            @Override
            public String getName() {
                return "spawner";
            }
        };
        public static final Type CEILING_SPAWNER = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                if (bounds.isInside((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.getBlockState(pos.above()).canOcclude()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, pos, rand, theme, secondaryTheme, stage);
                }
            }

            @Override
            public String getName() {
                return "ceiling_spawner";
            }
        };
        public static final Type SPAWNER_GRAVE = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                BlockPos p;
                BlockPos spawner;
                if (bounds.isInside((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, pos) && world.getBlockState(pos.below()).canOcclude()) {
                    DungeonModelFeature.placeChest(world, pos, (BlockState)DungeonBlocks.CHEST.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), theme, secondaryTheme, stage, rand);
                }
                if (bounds.isInside((Vec3i)(spawner = pos.relative(direction))) && !DungeonBuilder.isBlockProtected(world, spawner) && world.getBlockState(spawner.below()).canOcclude()) {
                    IBlockPlacementHandler.SPAWNER.place(world, DungeonBlocks.SPAWNER, spawner, rand, theme, secondaryTheme, stage);
                }
                if (bounds.isInside((Vec3i)(p = pos.relative(direction, 2))) && world.getBlockState(p.below()).canOcclude()) {
                    world.setBlock(p, Blocks.QUARTZ_BLOCK.defaultBlockState(), 2);
                }
            }

            @Override
            public String getName() {
                return "spawner_grave";
            }
        };
        public static final Type EMPTY_GRAVE = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                BlockPos position = pos.relative(direction, 2);
                if (bounds.isInside((Vec3i)position) && world.getBlockState(position.below()).canOcclude()) {
                    world.setBlock(position, Blocks.QUARTZ_BLOCK.defaultBlockState(), 2);
                }
            }

            @Override
            public String getName() {
                return "empty_grave";
            }
        };
        public static final Type STAIRS = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                if (direction.getAxis() == Direction.Axis.Y) {
                    return;
                }
                for (int length = 0; length < 10; ++length) {
                    if (!bounds.isInside((Vec3i)pos)) continue;
                    int height = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos).getY();
                    if (height >= pos.getY()) break;
                    while (height < pos.getY()) {
                        BlockPos p = new BlockPos(pos.getX(), height, pos.getZ());
                        world.setBlock(p, theme.solid.get(world, p, rand), 2);
                        ++height;
                    }
                    world.setBlock(pos, (BlockState)theme.solidStairs.get(world, pos, rand).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite()), 2);
                    pos = pos.relative(direction).relative(Direction.DOWN);
                }
            }

            @Override
            public String getName() {
                return "stairs";
            }
        };
        public static final Type SEWER_HOLE = new Type(){
            private final BlockStateProvider AIR_WATER = new BlockStateProvider(){

                @Override
                public BlockState get(LevelAccessor world, BlockPos pos, RandomSource random, Rotation rotation) {
                    if (pos.getY() > 8) {
                        return Blocks.CAVE_AIR.defaultBlockState();
                    }
                    return Blocks.WATER.defaultBlockState();
                }

                @Override
                public JsonObject serialize() {
                    return null;
                }
            };
            private final BlockStateProvider AIR_LAVA = new BlockStateProvider(){

                @Override
                public BlockState get(LevelAccessor world, BlockPos pos, RandomSource random, Rotation rotation) {
                    if (pos.getY() > 8) {
                        return Blocks.CAVE_AIR.defaultBlockState();
                    }
                    return Blocks.LAVA.defaultBlockState();
                }

                @Override
                public JsonObject serialize() {
                    return null;
                }
            };

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                BlockStateProvider inner = stage < 4 ? this.AIR_WATER : this.AIR_LAVA;
                this.buildDown(world, pos, rand, bounds, inner);
                BlockPos east = pos.east();
                this.buildDown(world, east, rand, bounds, inner);
                BlockPos west = pos.west();
                this.buildDown(world, west, rand, bounds, inner);
                BlockPos north = pos.north();
                this.buildDown(world, north, rand, bounds, inner);
                BlockPos south = pos.south();
                this.buildDown(world, pos.south(), rand, bounds, inner);
                this.buildDown(world, east.north(), rand, bounds, inner);
                this.buildDown(world, east.south(), rand, bounds, inner);
                this.buildDown(world, west.north(), rand, bounds, inner);
                this.buildDown(world, west.south(), rand, bounds, inner);
                this.buildDown(world, east.offset(1, -1, 0), rand, bounds, theme.generic);
                this.buildDown(world, east.offset(1, -1, -1), rand, bounds, theme.generic);
                this.buildDown(world, east.offset(1, -1, 1), rand, bounds, theme.generic);
                this.buildDown(world, south.offset(0, -1, 1), rand, bounds, theme.generic);
                this.buildDown(world, south.offset(1, -1, 1), rand, bounds, theme.generic);
                this.buildDown(world, south.offset(-1, -1, 1), rand, bounds, theme.generic);
                this.buildDown(world, west.offset(-1, -1, 0), rand, bounds, theme.generic);
                this.buildDown(world, west.offset(-1, -1, -1), rand, bounds, theme.generic);
                this.buildDown(world, west.offset(-1, -1, 1), rand, bounds, theme.generic);
                this.buildDown(world, north.offset(0, -1, -1), rand, bounds, theme.generic);
                this.buildDown(world, north.offset(1, -1, -1), rand, bounds, theme.generic);
                this.buildDown(world, north.offset(-1, -1, -1), rand, bounds, theme.generic);
            }

            @Override
            public String getName() {
                return "sewer_hole";
            }

            private void buildDown(LevelAccessor world, BlockPos pos, RandomSource random, BoundingBox bounds, BlockStateProvider blockStateProvider) {
                if (!bounds.isInside((Vec3i)pos)) {
                    return;
                }
                while (pos.getY() > 0) {
                    if (!DungeonBuilder.isBlockProtected(world, pos) && !world.isEmptyBlock(pos)) {
                        world.setBlock(pos, blockStateProvider.get(world, pos, random), 2);
                        FluidState state = world.getFluidState(pos);
                        if (!state.isEmpty()) {
                            world.scheduleTick(pos, state.getType(), 0);
                        }
                    }
                    pos = pos.below();
                }
            }
        };
        public static final Type CROPS = new Type(){

            @Override
            public void place(LevelAccessor world, RandomSource rand, BlockPos pos, Direction direction, BoundingBox bounds, Theme theme, SecondaryTheme secondaryTheme, int stage) {
                if (bounds.isInside((Vec3i)pos) && world.getBlockState(pos.below()).getBlock() instanceof FarmBlock) {
                    BlockState crop = DungeonBlocks.CROPS.roll(rand).defaultBlockState();
                    if (crop.hasProperty((Property)BlockStateProperties.AGE_7)) {
                        crop = (BlockState)crop.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(4 + rand.nextInt(4)));
                    }
                    world.setBlock(pos, crop, 2);
                }
            }

            @Override
            public String getName() {
                return "crops";
            }
        };
        public static final ImmutableMap<String, Type> TYPES = new ImmutableMap.Builder().put((Object)CHEST.getName(), (Object)CHEST).put((Object)TNT_CHEST.getName(), (Object)TNT_CHEST).put((Object)SPAWNER_GRAVE.getName(), (Object)SPAWNER_GRAVE).put((Object)EMPTY_GRAVE.getName(), (Object)EMPTY_GRAVE).put((Object)SPAWNER.getName(), (Object)SPAWNER).put((Object)CEILING_SPAWNER.getName(), (Object)CEILING_SPAWNER).put((Object)STAIRS.getName(), (Object)STAIRS).put((Object)SEWER_HOLE.getName(), (Object)SEWER_HOLE).put((Object)CROPS.getName(), (Object)CROPS).build();

        public void place(LevelAccessor var1, RandomSource var2, BlockPos var3, Direction var4, BoundingBox var5, Theme var6, SecondaryTheme var7, int var8);

        public String getName();
    }

    private record Position(Vec3i position, Direction facing) {
        public static Position fromJson(JsonObject object) {
            Vec3i position = JSONUtils.getOffset(object);
            Direction facing = object.has("facing") ? Direction.valueOf((String)object.get("facing").getAsString().toUpperCase(Locale.ROOT)) : Direction.NORTH;
            return new Position(position, facing);
        }

        public DirectionalBlockPos worldPos(int x, int y, int z, Rotation rotation, DungeonModel model) {
            return switch (rotation) {
                case Rotation.CLOCKWISE_90 -> new DirectionalBlockPos(x + model.length - this.position.getZ() - 1, y + this.position.getY(), z + this.position.getX(), this.facing.getAxis() != Direction.Axis.Y ? this.facing.getClockWise() : this.facing);
                case Rotation.CLOCKWISE_180 -> new DirectionalBlockPos(x + model.width - this.position.getX() - 1, y + this.position.getY(), z + model.length - this.position.getZ() - 1, this.facing.getAxis() != Direction.Axis.Y ? this.facing.getOpposite() : this.facing);
                case Rotation.COUNTERCLOCKWISE_90 -> new DirectionalBlockPos(x + this.position.getZ(), y + this.position.getY(), z + model.width - this.position.getX() - 1, this.facing.getAxis() != Direction.Axis.Y ? this.facing.getCounterClockWise() : this.facing);
                default -> new DirectionalBlockPos(x + this.position.getX(), y + this.position.getY(), z + this.position.getZ(), this.facing);
            };
        }
    }

    public static class Instance {
        private final Type type;
        private final DirectionalBlockPos[] positions;

        private Instance(Type type, DirectionalBlockPos[] positions) {
            this.type = type;
            this.positions = positions;
        }

        public void place(LevelAccessor world, BoundingBox worldGenBounds, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int stage) {
            for (DirectionalBlockPos pos : this.positions) {
                this.type.place(world, rand, pos.position, pos.direction, worldGenBounds, theme, secondaryTheme, stage);
            }
        }

        public static Instance read(CompoundTag nbt) {
            Type type = (Type)Type.TYPES.get((Object)nbt.getString("type"));
            ListTag nbtPositions = nbt.getList("positions", 10);
            DirectionalBlockPos[] positions = new DirectionalBlockPos[nbtPositions.size()];
            for (int i = 0; i < nbtPositions.size(); ++i) {
                positions[i] = DirectionalBlockPos.fromNBT(nbtPositions.getCompound(i));
            }
            return new Instance(type, positions);
        }

        public void write(CompoundTag nbt) {
            nbt.putString("type", this.type.getName());
            ListTag positions = new ListTag();
            for (DirectionalBlockPos position : this.positions) {
                CompoundTag pos = new CompoundTag();
                position.writeToNBT(pos);
                positions.add((Object)pos);
            }
            nbt.put("positions", (Tag)positions);
        }
    }
}

