/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.exception.DatapackLoadException;

public class DungeonModels {
    public static final Hashtable<ResourceLocation, DungeonModel> KEY_TO_MODEL = new Hashtable();
    public static final Hashtable<Integer, DungeonModel> ID_TO_MODEL = new Hashtable();
    public static final Vec3i NO_OFFSET = new Vec3i(0, 0, 0);
    public static final ResourceLocation SECRET_ROOM_ENTRANCE = DungeonCrawl.locate("default/corridor/secret_room_entrance");
    public static final ResourceLocation STARTER_ROOM = DungeonCrawl.locate("default/room/starter_room");
    public static final ResourceLocation STAIRCASE_LAYER = DungeonCrawl.locate("default/staircase_layer");
    public static final ResourceLocation BOTTOM_STAIRS = DungeonCrawl.locate("default/stairs_bottom");
    public static final ResourceLocation TOP_STAIRS = DungeonCrawl.locate("default/stairs_top");
    public static final ResourceLocation LOOT_ROOM = DungeonCrawl.locate("default/loot_room");
    public static final ResourceLocation SECRET_ROOM = DungeonCrawl.locate("default/room/secret_room");
    private static ImmutableSet<ResourceLocation> KEYS;
    private static ImmutableSet.Builder<ResourceLocation> keySetBuilder;
    private static final String DIRECTORY = "models";

    public static synchronized void load(ResourceManager resourceManager) {
        ID_TO_MODEL.clear();
        KEY_TO_MODEL.clear();
        keySetBuilder = new ImmutableSet.Builder();
        resourceManager.listResources(DIRECTORY, s -> s.getPath().endsWith(".nbt")).forEach((file, resource) -> DungeonModels.load(file, resourceManager));
        KEYS = keySetBuilder.build();
    }

    private static void load(ResourceLocation file, ResourceManager resourceManager) {
        DungeonModel model = DungeonModels.loadModel(file, resourceManager);
        ResourceLocation metadataFile = new ResourceLocation(file.getNamespace(), file.getPath().substring(0, file.getPath().indexOf(".nbt")) + ".json");
        resourceManager.getResource(metadataFile).ifPresent(metadata -> {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)metadataFile);
            try {
                model.loadMetadata(JsonParser.parseReader((Reader)new InputStreamReader(metadata.open())).getAsJsonObject(), metadataFile);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load metadata for {}", (Object)file.getPath());
                e.printStackTrace();
            }
        });
    }

    private static DungeonModel loadModel(ResourceLocation resource, ResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource);
        try {
            CompoundTag nbt = NbtIo.readCompressed((InputStream)((Resource)resourceManager.getResource(resource).orElseThrow()).open(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            ResourceLocation key = DungeonCrawl.key(resource, DIRECTORY, ".nbt");
            DungeonModel model = ModelHandler.loadModelFromNBT(nbt, resource, key);
            KEY_TO_MODEL.put(key, model);
            keySetBuilder.add((Object)key);
            if (model.hasId()) {
                ID_TO_MODEL.put(model.getId(), model);
            }
            return model;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DatapackLoadException("Failed to load " + resource);
        }
    }

    public static ImmutableSet<ResourceLocation> getKeys() {
        return KEYS;
    }
}

