/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelLoader;

public class ModelHandler {
    public static final byte LATEST_MODEL_FORMAT = 1;

    public static void readAndSaveModelToFile(String name, ModelBlockDefinition definition, Level world, BlockPos pos, int width, int height, int length) {
        DungeonCrawl.LOGGER.info("Reading and saving {} to disk. Size: {}, {}, {}", (Object)name, (Object)width, (Object)height, (Object)length);
        ArrayList<DungeonModelBlock> blocks = new ArrayList<DungeonModelBlock>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockPos position = new BlockPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
                    BlockState state = world.getBlockState(position);
                    Block block = state.getBlock();
                    if (block == Blocks.BARRIER) continue;
                    blocks.add(DungeonModelBlock.fromBlockState(state, DungeonModelBlockType.get(block, definition), new Vec3i(x, y, z)));
                }
            }
        }
        ModelHandler.writeToFile(ModelHandler.toNbt(blocks, width, height, length), ((ServerLevel)world).getServer().getServerDirectory().getAbsolutePath() + "/models/" + name + ".nbt");
        DungeonCrawl.LOGGER.info("Done.");
    }

    public static void writeToFile(CompoundTag nbt, String path) {
        try {
            DungeonCrawl.LOGGER.info("Writing a model to disk at {}. ", (Object)path);
            File file = new File(path);
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            Files.deleteIfExists(file.toPath());
            Files.createFile(file.toPath(), new FileAttribute[0]);
            NbtIo.writeCompressed((CompoundTag)nbt, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static CompoundTag toNbt(List<DungeonModelBlock> blocks, int width, int height, int length) {
        CompoundTag nbt = new CompoundTag();
        nbt.putByte("format", (byte)1);
        nbt.putByte("width", (byte)width);
        nbt.putByte("height", (byte)height);
        nbt.putByte("length", (byte)length);
        ListTag _blocks = new ListTag();
        blocks.forEach(block -> _blocks.add((Object)block.toNBT()));
        nbt.put("blocks", (Tag)_blocks);
        return nbt;
    }

    public static DungeonModel loadModelFromNBT(CompoundTag nbt, ResourceLocation file, ResourceLocation key) {
        int format = nbt.getInt("format");
        if (format == 1) {
            return ModelLoader.VERSION_1.load(nbt, file, key);
        }
        return ModelLoader.LEGACY.load(nbt, file, key);
    }
}

